/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.annotations.munit;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.datasense.impl.model.annotations.munit.MUnitDeclaration;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MuleFlowNode;

public class MUnitDeclarationsAnnotation
implements AstNodeAnnotation {
    private final Map<String, MUnitDeclaration> mUnitDeclarations = new HashMap<String, MUnitDeclaration>();

    public Optional<MuleFlowNode> getBeforeTestMuleFlowNode(MuleFlowNode muleFlowNode) {
        return this.get(muleFlowNode).map(MUnitDeclaration::getBeforeTestMuleFlowNode);
    }

    public Optional<MuleFlowNode> getAfterTestMuleFlowNode(MuleFlowNode muleFlowNode) {
        return this.get(muleFlowNode).map(MUnitDeclaration::getAfterTestMuleFlowNode);
    }

    public Optional<MuleFlowNode> getBeforeSuiteMuleFlowNode(MuleFlowNode muleFlowNode) {
        return this.get(muleFlowNode).map(MUnitDeclaration::getBeforeSuiteMuleFlowNode);
    }

    public Optional<MuleFlowNode> getAfterSuiteMuleFlowNode(MuleFlowNode muleFlowNode) {
        return this.get(muleFlowNode).map(MUnitDeclaration::getAfterSuiteMuleFlowNode);
    }

    public void setBeforeTestMuleFlowNode(MuleFlowNode beforeTestMuleFlowNode) {
        MUnitDeclaration mUnitDeclaration = this.getOrCreate(beforeTestMuleFlowNode);
        mUnitDeclaration.setBeforeTestMuleFlowNode(beforeTestMuleFlowNode);
    }

    public void setAfterTestMuleFlowNode(MuleFlowNode afterTestMuleFlowNode) {
        MUnitDeclaration mUnitDeclaration = this.getOrCreate(afterTestMuleFlowNode);
        mUnitDeclaration.setAfterTestMuleFlowNode(afterTestMuleFlowNode);
    }

    public void setBeforeSuiteMuleFlowNode(MuleFlowNode beforeSuiteMuleFlowNode) {
        MUnitDeclaration mUnitDeclaration = this.getOrCreate(beforeSuiteMuleFlowNode);
        mUnitDeclaration.setBeforeSuiteMuleFlowNode(beforeSuiteMuleFlowNode);
    }

    public void setAfterSuiteMuleFlowNode(MuleFlowNode afterSuiteMuleFlowNode) {
        MUnitDeclaration mUnitDeclaration = this.getOrCreate(afterSuiteMuleFlowNode);
        mUnitDeclaration.setAfterSuiteMuleFlowNode(afterSuiteMuleFlowNode);
    }

    private String getKey(MuleFlowNode muleFlowNode) {
        return (String)muleFlowNode.getComponentModel().getMetadata().getFileName().orElseThrow(() -> new IllegalArgumentException("Config file not set."));
    }

    private MUnitDeclaration getOrCreate(MuleFlowNode muleFlowNode) {
        String key = this.getKey(muleFlowNode);
        MUnitDeclaration mUnitDeclaration = this.mUnitDeclarations.get(key);
        if (mUnitDeclaration == null) {
            mUnitDeclaration = new MUnitDeclaration();
            this.mUnitDeclarations.put(key, mUnitDeclaration);
        }
        return mUnitDeclaration;
    }

    private Optional<MUnitDeclaration> get(MuleFlowNode muleFlowNode) {
        String key = this.getKey(muleFlowNode);
        return Optional.ofNullable(this.mUnitDeclarations.get(key));
    }
}

