/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.event;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.event.LiteralTypeExpr;
import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;

public class LiteralTypeExprTest {
    @Test(expected=NullPointerException.class)
    public void testConstructorWithNullShouldThrowException() {
        new LiteralTypeExpr(null);
    }

    @Test
    public void testConstructorWithValidType() {
        MetadataType metadataType = (MetadataType)Mockito.mock(StringType.class);
        LiteralTypeExpr expr = new LiteralTypeExpr(metadataType);
        Assert.assertNotNull((String)"LiteralTypeExpr instance should not be null", (Object)expr);
    }

    @Test
    public void testResolveTypeReturnsOriginalType() {
        MetadataType metadataType = (MetadataType)Mockito.mock(StringType.class);
        LiteralTypeExpr expr = new LiteralTypeExpr(metadataType);
        MuleEventMetadataType eventMetadataType = (MuleEventMetadataType)Mockito.mock(MuleEventMetadataType.class);
        ResolveTypeContext resolveTypeContext = (ResolveTypeContext)Mockito.mock(ResolveTypeContext.class);
        MetadataType result = expr.resolveType(eventMetadataType, resolveTypeContext);
        Assert.assertEquals((String)"resolveType should return the original metadata type", (Object)metadataType, (Object)result);
        Mockito.verifyNoInteractions((Object[])new Object[]{eventMetadataType, resolveTypeContext});
    }

    @Test
    public void testResolveInputTypeDoesNotModifyBuilder() {
        MetadataType metadataType = (MetadataType)Mockito.mock(StringType.class);
        LiteralTypeExpr expr = new LiteralTypeExpr(metadataType);
        MetadataType inputType = (MetadataType)Mockito.mock(MetadataType.class);
        MuleEventMetadataTypeBuilder builder = (MuleEventMetadataTypeBuilder)Mockito.mock(MuleEventMetadataTypeBuilder.class);
        ResolveTypeContext resolveTypeContext = (ResolveTypeContext)Mockito.mock(ResolveTypeContext.class);
        expr.resolveInputType(inputType, builder, resolveTypeContext);
        Mockito.verifyNoInteractions((Object[])new Object[]{inputType, builder, resolveTypeContext});
    }
}

