/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.ast2.test.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.util.ExpressionLanguageMetadataServiceUtils;
import org.mule.datasense.impl.util.matchers.MetadataTypeMatcher;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.dw.DwTypeWriter;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;

@RunWith(value=Parameterized.class)
public class AsMessageMetadataTypeTest {
    private final String name;
    private final Consumer<TypeBuilder> typeBuilderConsumer;

    public AsMessageMetadataTypeTest(String name, Consumer<TypeBuilder> typeBuilderConsumer) {
        this.name = name;
        this.typeBuilderConsumer = typeBuilderConsumer;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"empty", messageMetadataTypeBuilder -> {}}, {"payload", messageMetadataTypeBuilder -> messageMetadataTypeBuilder.payload().stringType()}, {"attributes", messageMetadataTypeBuilder -> messageMetadataTypeBuilder.attributes().stringType()}, {"payloadWithAttributes", messageMetadataTypeBuilder -> {
            messageMetadataTypeBuilder.payload().stringType();
            messageMetadataTypeBuilder.attributes().stringType();
        }});
    }

    @Test
    public void test() {
        MessageMetadataTypeBuilder messageMetadataTypeBuilder = new MessageMetadataTypeBuilder();
        this.typeBuilderConsumer.accept((TypeBuilder)messageMetadataTypeBuilder);
        MessageMetadataType messageMetadataType = messageMetadataTypeBuilder.build();
        MessageMetadataType newMessageMetadataType = (MessageMetadataType)TypeUtils.asMessageMetadataType((MetadataType)messageMetadataType).orElseThrow(AssertionError::new);
        Assert.assertThat((Object)newMessageMetadataType, (Matcher)new MetadataTypeMatcher.IsAs(TypesHelper.toString((MetadataType)messageMetadataType)));
    }

    @Test
    public void testUsingWeaveSerialization() {
        MessageMetadataTypeBuilder messageMetadataTypeBuilder = new MessageMetadataTypeBuilder();
        this.typeBuilderConsumer.accept((TypeBuilder)messageMetadataTypeBuilder);
        MessageMetadataType messageMetadataType = messageMetadataTypeBuilder.build();
        MessageMetadataType newMessageMetadataType = this.createMetadataType(messageMetadataType);
        Assert.assertThat((Object)newMessageMetadataType, (Matcher)new MetadataTypeMatcher.IsAs(TypesHelper.toString((MetadataType)messageMetadataType)));
    }

    private MessageMetadataType createMetadataType(MessageMetadataType messageMetadataType) {
        DwTypeWriter dwTypeWriter = new DwTypeWriter(ExpressionLanguageMetadataServiceUtils.createExpressionLanguageMetadataService());
        String name = "aType";
        String serialized = dwTypeWriter.write((MetadataType)messageMetadataType, "aType");
        TypeLoader typeLoader = ExpressionLanguageMetadataServiceUtils.createExpressionLanguageMetadataService().createTypeLoader(serialized, MetadataFormat.JAVA);
        MetadataType newMetadataType = (MetadataType)typeLoader.load("aType").orElseThrow(IllegalArgumentException::new);
        Assert.assertFalse((boolean)(newMetadataType instanceof MessageMetadataType));
        return (MessageMetadataType)TypeUtils.asMessageMetadataType((MetadataType)newMetadataType).orElseThrow(AssertionError::new);
    }
}

