/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.api.metadataprovider;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;

public class ApplicationModelTest {
    private ApplicationModel applicationModel;

    @Before
    public void setUp() {
        this.applicationModel = new TestApplicationModel();
    }

    @Test
    public void testFindResourceWithDefaultImplementation() {
        Optional resourceOptional = this.applicationModel.findResource("any-resource");
        Assert.assertNotNull((String)"Resource optional should not be null", (Object)resourceOptional);
        Assert.assertFalse((String)"Default implementation should return empty optional", (boolean)resourceOptional.isPresent());
    }

    @Test
    public void testCustomImplementationOfFindResource() {
        TestApplicationModelWithResource customModel = new TestApplicationModelWithResource();
        Optional existingResource = customModel.findResource("existing-resource");
        Assert.assertNotNull((String)"Resource optional should not be null", (Object)existingResource);
        Assert.assertTrue((String)"Custom implementation should return URI for existing resource", (boolean)existingResource.isPresent());
        Assert.assertEquals((String)"Resource URI should match expected", (Object)URI.create("file:///test"), existingResource.get());
        Optional nonExistingResource = customModel.findResource("non-existing-resource");
        Assert.assertNotNull((String)"Resource optional should not be null for non-existing resource", (Object)nonExistingResource);
        Assert.assertFalse((String)"Custom implementation should return empty optional for non-existing resource", (boolean)nonExistingResource.isPresent());
    }

    private static class TestApplicationModel
    implements ApplicationModel {
        private final ArtifactAst artifactAst = (ArtifactAst)Mockito.mock(ArtifactAst.class);

        private TestApplicationModel() {
        }

        public Optional<ComponentAst> findNamedComponent(String name) {
            return Optional.empty();
        }

        public List<String> findTypesDataList() {
            return Arrays.asList("type1", "type2");
        }

        public ArtifactAst getMuleApplicationModel() {
            return this.artifactAst;
        }
    }

    private static class TestApplicationModelWithResource
    implements ApplicationModel {
        private final ArtifactAst artifactAst = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        private final URI testUri = URI.create("file:///test");

        private TestApplicationModelWithResource() {
        }

        public Optional<ComponentAst> findNamedComponent(String name) {
            return Optional.empty();
        }

        public List<String> findTypesDataList() {
            return Arrays.asList("type1", "type2");
        }

        public ArtifactAst getMuleApplicationModel() {
            return this.artifactAst;
        }

        public Optional<URI> findResource(String resource) {
            if ("existing-resource".equals(resource)) {
                return Optional.of(this.testUri);
            }
            return Optional.empty();
        }
    }
}

