/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.ast;

import java.util.Optional;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.ast.api.ComponentAst;

public class MuleApplicationNodeTest {
    private MuleApplicationNode muleApplicationNode;
    @Mock
    private ComponentIdentifier mockComponentIdentifier;
    @Mock
    private MuleFlowNode mockMuleFlowNode1;
    @Mock
    private MuleFlowNode mockMuleFlowNode2;
    @Mock
    private ComponentLocation mockComponentLocation;
    @Mock
    private MessageProcessorNode mockMessageProcessorNode;
    @Mock
    private ComponentAst mockComponentModel;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockMuleFlowNode1.getName()).thenReturn((Object)"flow1");
        Mockito.when((Object)this.mockMuleFlowNode2.getName()).thenReturn((Object)"flow2");
        this.muleApplicationNode = new MuleApplicationNode(this.mockComponentIdentifier, Stream.of(this.mockMuleFlowNode1, this.mockMuleFlowNode2));
    }

    @Test
    public void testGetMuleFlowNodes() {
        Assert.assertEquals((long)2L, (long)this.muleApplicationNode.getMuleFlowNodes().count());
    }

    @Test
    public void testRegister() {
        Mockito.when((Object)this.mockComponentLocation.getLocation()).thenReturn((Object)"location1");
        Mockito.when((Object)this.mockMessageProcessorNode.getComponentModel()).thenReturn((Object)this.mockComponentModel);
        Mockito.when((Object)this.mockComponentModel.getComponentId()).thenReturn(Optional.of("componentId1"));
        this.muleApplicationNode.register(this.mockComponentLocation, this.mockMessageProcessorNode);
        Assert.assertTrue((boolean)this.muleApplicationNode.findMessageProcessorNode(Location.builder().globalName("location1").build()).isPresent());
        Assert.assertTrue((boolean)this.muleApplicationNode.findMessageProcessorNode("location1").isPresent());
        Assert.assertTrue((boolean)this.muleApplicationNode.findComponentLocationByName("componentId1").isPresent());
    }

    @Test(expected=IllegalStateException.class)
    public void testRegisterDuplicate() {
        this.muleApplicationNode.register(this.mockComponentLocation, this.mockMessageProcessorNode);
        this.muleApplicationNode.register(this.mockComponentLocation, this.mockMessageProcessorNode);
    }

    @Test
    public void testFindComponentLocationByName() {
        Mockito.when((Object)this.mockComponentLocation.getLocation()).thenReturn((Object)"location1");
        Mockito.when((Object)this.mockMessageProcessorNode.getComponentModel()).thenReturn((Object)this.mockComponentModel);
        Mockito.when((Object)this.mockComponentModel.getComponentId()).thenReturn(Optional.of("componentId1"));
        this.muleApplicationNode.register(this.mockComponentLocation, this.mockMessageProcessorNode);
        Assert.assertTrue((boolean)this.muleApplicationNode.findComponentLocationByName("componentId1").isPresent());
    }

    @Test
    public void testFindMessageProcessorNodeByName() {
        Mockito.when((Object)this.mockComponentLocation.getLocation()).thenReturn((Object)"location1");
        Mockito.when((Object)this.mockMessageProcessorNode.getComponentModel()).thenReturn((Object)this.mockComponentModel);
        Mockito.when((Object)this.mockComponentModel.getComponentId()).thenReturn(Optional.of("componentId1"));
        this.muleApplicationNode.register(this.mockComponentLocation, this.mockMessageProcessorNode);
        Assert.assertTrue((boolean)this.muleApplicationNode.findMessageProcessorNodeByName("componentId1").isPresent());
    }

    @Test
    public void testFindMessageProcessorNodeByLocation() {
        Mockito.when((Object)this.mockComponentLocation.getLocation()).thenReturn((Object)"location1");
        this.muleApplicationNode.register(this.mockComponentLocation, this.mockMessageProcessorNode);
        Assert.assertTrue((boolean)this.muleApplicationNode.findMessageProcessorNode(Location.builder().globalName("location1").build()).isPresent());
    }

    @Test
    public void testFindMuleFlowNode() {
        Optional result = this.muleApplicationNode.findMuleFlowNode("flow1");
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)this.mockMuleFlowNode1, result.get());
    }

    @Test
    public void testFindMessageProcessorNodes() {
        Mockito.when((Object)this.mockMessageProcessorNode.isRootMessageProcessorNode()).thenReturn((Object)false);
        this.muleApplicationNode.register(this.mockComponentLocation, this.mockMessageProcessorNode);
        Assert.assertEquals((long)1L, (long)this.muleApplicationNode.findMessageProcessorNodes().count());
    }

    @Test
    public void testFindMessageProcessorNodesIncludingRoot() {
        Mockito.when((Object)this.mockMessageProcessorNode.isRootMessageProcessorNode()).thenReturn((Object)true);
        this.muleApplicationNode.register(this.mockComponentLocation, this.mockMessageProcessorNode);
        Assert.assertEquals((long)1L, (long)this.muleApplicationNode.findMessageProcessorNodes(true).count());
        Assert.assertEquals((long)0L, (long)this.muleApplicationNode.findMessageProcessorNodes(false).count());
    }
}

