/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.model;

import java.util.HashSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.operation.InputMapping;
import org.mule.datasense.impl.model.operation.OperationCall;
import org.mule.datasense.impl.model.operation.OperationCallBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.runtime.api.meta.model.error.ErrorModel;

public class OperationCallBuilderTest {
    private OperationCallBuilder builder;

    @Before
    public void setUp() {
        this.builder = new OperationCallBuilder();
    }

    @Test
    public void testName() {
        OperationCall call = this.builder.name("testOperation").build();
        Assert.assertEquals((Object)"testOperation", (Object)call.getName());
    }

    @Test
    public void testTarget() {
        OperationCall call = this.builder.target("testTarget").build();
        Assert.assertEquals((Object)"testTarget", call.getTarget().get());
    }

    @Test
    public void testErrors() {
        HashSet<ErrorModel> errors = new HashSet<ErrorModel>();
        ErrorModel error1 = (ErrorModel)Mockito.mock(ErrorModel.class);
        ErrorModel error2 = (ErrorModel)Mockito.mock(ErrorModel.class);
        errors.add(error1);
        errors.add(error2);
        OperationCall call = this.builder.errors(errors).build();
        Assert.assertEquals(errors, (Object)call.getErrorModels());
    }

    @Test
    public void testTargetValue() {
        OperationCall call = this.builder.targetValue("testTargetValue").build();
        Assert.assertEquals((Object)"testTargetValue", (Object)call.getTargetValueExpression());
    }

    @Test
    public void testOutputMimeType() {
        OperationCall call = this.builder.outputMimeType("application/json").build();
        Assert.assertEquals((Object)"application/json", (Object)call.getOutputMimeType());
    }

    @Test
    public void testInput() {
        OperationCall call = this.builder.input(input -> input.parameter(param -> param.name("testParam").type(null)).argument(arg -> arg.expression("testExpression").value("testValue"))).build();
        InputMapping inputMapping = (InputMapping)call.getInputMappings().iterator().next();
        Assert.assertEquals((Object)"testParam", (Object)inputMapping.getInputParameter().getName());
        Assert.assertEquals((Object)"testExpression", (Object)inputMapping.getInputArgument().getExpression());
        Assert.assertEquals((Object)"testValue", (Object)inputMapping.getInputArgument().getValue());
    }

    @Test
    public void testReturnType() {
        MetadataType returnType = (MetadataType)Mockito.mock(MetadataType.class);
        OperationCall call = this.builder.returnType(returnType).build();
        Assert.assertEquals((Object)returnType, (Object)call.getReturnType());
    }

    @Test
    public void testReturnTypeWithMessageMetadataType() {
        MessageMetadataTypeBuilder messageBuilder = new MessageMetadataTypeBuilder();
        MessageMetadataType previousReturnType = messageBuilder.build();
        MessageMetadataType newReturnType = messageBuilder.build();
        OperationCall call = this.builder.returnType((MetadataType)previousReturnType).returnType((MetadataType)newReturnType).build();
        Assert.assertTrue((boolean)(call.getReturnType() instanceof MessageMetadataType));
    }

    @Test
    public void testBuildWithMultipleInputs() {
        OperationCall call = this.builder.name("testOperation").input(input -> input.parameter(param -> param.name("param1").type(null)).argument(arg -> arg.expression("expr1").value("value1"))).input(input -> input.parameter(param -> param.name("param2").type(null)).argument(arg -> arg.expression("expr2").value("value2"))).build();
        Assert.assertEquals((Object)"testOperation", (Object)call.getName());
        Assert.assertEquals((long)2L, (long)call.getInputMappings().count());
    }

    @Test
    public void testBuildWithOutputParameter() {
        OperationCall call = this.builder.input(input -> input.parameter(param -> param.name("target").type(null)).argument(arg -> arg.expression("outputExpr").value("outputValue"))).build();
        Assert.assertEquals((long)0L, (long)call.getInputMappings().count());
    }
}

