/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.types;

import java.util.Arrays;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.types.MetadataTypeTransform;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;

@Ignore(value="This test class has issues with ObjectFieldType mock setup")
public class MetadataTypeTransformTest {
    private BaseTypeBuilder typeBuilder;
    private MetadataType stringType;
    private MetadataType numberType;
    private MetadataType booleanType;
    private MetadataType arrayType;
    private ObjectType objectType;
    private MessageMetadataType messageType;

    @Before
    public void setup() {
        this.typeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
        this.stringType = this.typeBuilder.stringType().build();
        this.numberType = this.typeBuilder.numberType().build();
        this.booleanType = this.typeBuilder.booleanType().build();
        this.arrayType = this.typeBuilder.arrayType().of(this.stringType).build();
        this.objectType = (ObjectType)Mockito.mock(ObjectType.class);
        ObjectFieldType field1 = (ObjectFieldType)Mockito.mock(ObjectFieldType.class);
        ObjectFieldType field2 = (ObjectFieldType)Mockito.mock(ObjectFieldType.class);
        Mockito.when((Object)field1.getValue()).thenReturn((Object)this.stringType);
        Mockito.when((Object)field1.getKey().getName().getLocalPart()).thenReturn((Object)"field1");
        Mockito.when((Object)field2.getValue()).thenReturn((Object)this.numberType);
        Mockito.when((Object)field2.getKey().getName().getLocalPart()).thenReturn((Object)"field2");
        Mockito.when((Object)this.objectType.getFields()).thenReturn(Arrays.asList(field1, field2));
        Mockito.when((Object)this.objectType.getFieldByName("field1")).thenReturn(Optional.of(field1));
        Mockito.when((Object)this.objectType.getFieldByName("field2")).thenReturn(Optional.of(field2));
        MessageMetadataTypeBuilder messageBuilder = MessageMetadataType.builder();
        messageBuilder.payload(this.stringType);
        messageBuilder.attributes(this.numberType);
        this.messageType = messageBuilder.build();
    }

    @Test
    public void testTransformWithIdentityFunction() {
        MetadataTypeTransform transform = new MetadataTypeTransform();
        Assert.assertEquals(this.stringType.getClass(), transform.transform(this.stringType).getClass());
        Assert.assertEquals(this.numberType.getClass(), transform.transform(this.numberType).getClass());
        Assert.assertEquals(this.booleanType.getClass(), transform.transform(this.booleanType).getClass());
        Assert.assertEquals(this.arrayType.getClass(), transform.transform(this.arrayType).getClass());
    }

    @Test
    public void testTransformObjectType() {
        MetadataTypeTransform transform = new MetadataTypeTransform();
        MetadataType result = transform.transform((MetadataType)this.objectType);
        Assert.assertTrue((boolean)(result instanceof ObjectType));
        ObjectType resultObj = (ObjectType)result;
        Assert.assertEquals((long)2L, (long)resultObj.getFields().size());
        MetadataType field1Type = ((ObjectFieldType)resultObj.getFieldByName("field1").get()).getValue();
        Assert.assertTrue((boolean)(field1Type instanceof StringType));
        MetadataType field2Type = ((ObjectFieldType)resultObj.getFieldByName("field2").get()).getValue();
        Assert.assertTrue((boolean)(field2Type instanceof NumberType));
    }

    @Test
    public void testTransformArrayType() {
        MetadataTypeTransform transform = new MetadataTypeTransform();
        MetadataType result = transform.transform(this.arrayType);
        Assert.assertTrue((boolean)(result instanceof ArrayType));
        ArrayType resultArray = (ArrayType)result;
        MetadataType itemType = resultArray.getType();
        Assert.assertTrue((boolean)(itemType instanceof StringType));
    }

    @Test
    public void testTransformBooleanType() {
        MetadataTypeTransform transform = new MetadataTypeTransform();
        MetadataType result = transform.transform(this.booleanType);
        Assert.assertTrue((boolean)(result instanceof BooleanType));
    }

    @Test
    public void testTransformStringType() {
        MetadataTypeTransform transform = new MetadataTypeTransform();
        MetadataType result = transform.transform(this.stringType);
        Assert.assertTrue((boolean)(result instanceof StringType));
    }
}

