/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.annotations.OperationCallBuilderAnnotation;
import org.mule.datasense.impl.model.annotations.metadata.OperationModelAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.operation.OperationCallBuilder;
import org.mule.datasense.impl.phases.annotators.StaticDslOperationAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.ast.api.ComponentAst;

public class StaticDslOperationAnnotatorTest {
    private StaticDslOperationAnnotator annotator;
    private MessageProcessorNode messageProcessorNode;
    private AnnotatingMuleAstVisitorContext context;
    private ComponentAst componentAst;
    private OperationModel operationModel;
    private OperationCallBuilder operationCallBuilder;

    @Before
    public void setUp() {
        this.annotator = new StaticDslOperationAnnotator();
        this.messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.context = (AnnotatingMuleAstVisitorContext)Mockito.mock(AnnotatingMuleAstVisitorContext.class);
        this.componentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.operationModel = (OperationModel)Mockito.mock(OperationModel.class);
        this.operationCallBuilder = (OperationCallBuilder)Mockito.mock(OperationCallBuilder.class);
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)this.componentAst);
        Mockito.when((Object)this.componentAst.getModel(OperationModel.class)).thenReturn(Optional.of(this.operationModel));
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)((OutputModel)Mockito.mock(OutputModel.class)));
        Mockito.when((Object)this.operationModel.getOutputAttributes()).thenReturn((Object)((OutputModel)Mockito.mock(OutputModel.class)));
    }

    @Test
    public void testAnnotateWithOperationModel() {
        OperationCallBuilderAnnotation annotation = (OperationCallBuilderAnnotation)Mockito.mock(OperationCallBuilderAnnotation.class);
        Mockito.when((Object)((OperationCallBuilderAnnotation)this.messageProcessorNode.getOrCreateAnnotation((Class)Mockito.eq(OperationCallBuilderAnnotation.class), (Supplier)Mockito.any()))).thenReturn((Object)annotation);
        Mockito.when((Object)annotation.getOperationCallBuilder()).thenReturn((Object)((OperationCallBuilder)Mockito.mock(OperationCallBuilder.class)));
        Mockito.when((Object)this.componentAst.getModel(OperationModel.class)).thenReturn(Optional.of(this.operationModel));
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)((OutputModel)Mockito.mock(OutputModel.class)));
        this.annotator.annotate(this.messageProcessorNode, this.context);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((OperationModelAnnotation)Mockito.any(OperationModelAnnotation.class)));
    }

    @Test
    public void testAnnotateWithOperationCallBuilder() {
        OperationCallBuilderAnnotation annotation = (OperationCallBuilderAnnotation)Mockito.mock(OperationCallBuilderAnnotation.class);
        Mockito.when((Object)((OperationCallBuilderAnnotation)this.messageProcessorNode.getOrCreateAnnotation((Class)Mockito.eq(OperationCallBuilderAnnotation.class), (Supplier)Mockito.any()))).thenReturn((Object)annotation);
        Mockito.when((Object)annotation.getOperationCallBuilder()).thenReturn((Object)this.operationCallBuilder);
        this.annotator.annotate(this.messageProcessorNode, this.context);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).getOrCreateAnnotation((Class)Mockito.eq(OperationCallBuilderAnnotation.class), (Supplier)Mockito.any());
        ((OperationCallBuilderAnnotation)Mockito.verify((Object)annotation)).getOperationCallBuilder();
    }

    @Test
    public void testAnnotateWithTarget() {
        OperationCallBuilderAnnotation annotation = (OperationCallBuilderAnnotation)Mockito.mock(OperationCallBuilderAnnotation.class);
        Mockito.when((Object)((OperationCallBuilderAnnotation)this.messageProcessorNode.getOrCreateAnnotation((Class)Mockito.eq(OperationCallBuilderAnnotation.class), (Supplier)Mockito.any()))).thenReturn((Object)annotation);
        Mockito.when((Object)annotation.getOperationCallBuilder()).thenReturn((Object)this.operationCallBuilder);
        this.annotator.annotate(this.messageProcessorNode, this.context);
        Assert.assertNotNull((Object)this.messageProcessorNode);
    }

    @Test
    public void testAnnotateWithTargetValue() {
        OperationCallBuilderAnnotation annotation = (OperationCallBuilderAnnotation)Mockito.mock(OperationCallBuilderAnnotation.class);
        Mockito.when((Object)((OperationCallBuilderAnnotation)this.messageProcessorNode.getOrCreateAnnotation((Class)Mockito.eq(OperationCallBuilderAnnotation.class), (Supplier)Mockito.any()))).thenReturn((Object)annotation);
        Mockito.when((Object)annotation.getOperationCallBuilder()).thenReturn((Object)this.operationCallBuilder);
        this.annotator.annotate(this.messageProcessorNode, this.context);
        Assert.assertNotNull((Object)this.context);
    }

    @Test
    public void testAnnotateWithOutputMimeType() {
        OperationCallBuilderAnnotation annotation = (OperationCallBuilderAnnotation)Mockito.mock(OperationCallBuilderAnnotation.class);
        Mockito.when((Object)((OperationCallBuilderAnnotation)this.messageProcessorNode.getOrCreateAnnotation((Class)Mockito.eq(OperationCallBuilderAnnotation.class), (Supplier)Mockito.any()))).thenReturn((Object)annotation);
        Mockito.when((Object)annotation.getOperationCallBuilder()).thenReturn((Object)this.operationCallBuilder);
        this.annotator.annotate(this.messageProcessorNode, this.context);
        Assert.assertNotNull((Object)this.context);
    }
}

