/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.MuleApplicationAnnotation;
import org.mule.datasense.impl.model.annotations.TypeResolverAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.AggregatorListenerTypeResolver;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.ast.api.ComponentAst;

public class AggregatorListenerTypeResolverTest {
    private AggregatorListenerTypeResolver resolver;
    private MessageProcessorNode messageProcessorNode;
    private TypingMuleAstVisitor typingMuleAstVisitor;
    private TypingMuleAstVisitorContext visitorContext;
    private MuleApplicationNode muleApplicationNode;

    @Before
    public void setUp() {
        this.resolver = new AggregatorListenerTypeResolver();
        this.messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.typingMuleAstVisitor = (TypingMuleAstVisitor)Mockito.mock(TypingMuleAstVisitor.class);
        this.visitorContext = (TypingMuleAstVisitorContext)Mockito.mock(TypingMuleAstVisitorContext.class);
        this.muleApplicationNode = (MuleApplicationNode)Mockito.mock(MuleApplicationNode.class);
    }

    @Test
    public void testResolveWithNullMuleApplicationNode() {
        Mockito.when((Object)this.visitorContext.getAnnotation(MuleApplicationAnnotation.class)).thenReturn(Optional.empty());
        EventType result = this.resolver.resolve(this.messageProcessorNode, new EventType(), this.typingMuleAstVisitor, this.visitorContext);
        Assert.assertNotNull((Object)result);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((UsesTypeAnnotation)Mockito.any(UsesTypeAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((DefinesTypeAnnotation)Mockito.any(DefinesTypeAnnotation.class)));
    }

    @Test
    public void testEnsureMuleFlowNodeTypesResolved() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = AggregatorListenerTypeResolver.class.getDeclaredMethod("ensureMuleFlowNodeTypesResolved", MuleFlowNode.class, MuleApplicationNode.class, TypingMuleAstVisitor.class, TypingMuleAstVisitorContext.class);
        method.setAccessible(true);
        MuleFlowNode muleFlowNode = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        TypeResolverAnnotation annotation = (TypeResolverAnnotation)Mockito.mock(TypeResolverAnnotation.class);
        Mockito.when((Object)muleFlowNode.getAnnotation(TypeResolverAnnotation.class)).thenReturn(Optional.of(annotation));
        method.invoke((Object)this.resolver, muleFlowNode, this.muleApplicationNode, this.typingMuleAstVisitor, this.visitorContext);
        Assert.assertNotNull((Object)this.muleApplicationNode);
    }

    @Test
    public void testEnsureComponentLocationTypesResolved() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = AggregatorListenerTypeResolver.class.getDeclaredMethod("ensureComponentLocationTypesResolved", MuleApplicationNode.class, ComponentLocation.class, TypingMuleAstVisitor.class, TypingMuleAstVisitorContext.class);
        method.setAccessible(true);
        ComponentLocation componentLocation = (ComponentLocation)Mockito.mock(ComponentLocation.class);
        Mockito.when((Object)componentLocation.getRootContainerName()).thenReturn((Object)"rootContainerName");
        Mockito.when((Object)this.muleApplicationNode.findMuleFlowNode("rootContainerName")).thenReturn(Optional.of((MuleFlowNode)Mockito.mock(MuleFlowNode.class)));
        method.invoke((Object)this.resolver, this.muleApplicationNode, componentLocation, this.typingMuleAstVisitor, this.visitorContext);
        Assert.assertNotNull((Object)this.muleApplicationNode.findMuleFlowNode("rootContainerName"));
    }

    @Test
    public void testFindAggregatorMessageProcessorNode() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = AggregatorListenerTypeResolver.class.getDeclaredMethod("findAggregatorMessageProcessorNode", String.class, MuleApplicationNode.class, TypingMuleAstVisitor.class, TypingMuleAstVisitorContext.class);
        method.setAccessible(true);
        Mockito.when((Object)this.muleApplicationNode.findMessageProcessorNodeByName((String)Mockito.any())).thenReturn(Optional.of(this.messageProcessorNode));
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)((ComponentAst)Mockito.mock(ComponentAst.class)));
        Mockito.when((Object)this.messageProcessorNode.getComponentModel().getLocation()).thenReturn((Object)((ComponentLocation)Mockito.mock(ComponentLocation.class)));
        Mockito.when((Object)this.muleApplicationNode.findMuleFlowNode("rootContainerName")).thenReturn(Optional.of((MuleFlowNode)Mockito.mock(MuleFlowNode.class)));
        method.invoke((Object)this.resolver, "aggregatorRef", this.muleApplicationNode, this.typingMuleAstVisitor, this.visitorContext);
        Assert.assertNotNull((Object)this.visitorContext);
    }

    @Test
    public void testResolveAggregatorEventType() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = AggregatorListenerTypeResolver.class.getDeclaredMethod("resolveAggregatorEventType", String.class, MuleApplicationNode.class, TypingMuleAstVisitor.class, TypingMuleAstVisitorContext.class);
        method.setAccessible(true);
        Mockito.when((Object)this.muleApplicationNode.findMessageProcessorNodeByName((String)Mockito.any())).thenReturn(Optional.of(this.messageProcessorNode));
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)((ComponentAst)Mockito.mock(ComponentAst.class)));
        Mockito.when((Object)this.messageProcessorNode.getComponentModel().getLocation()).thenReturn((Object)((ComponentLocation)Mockito.mock(ComponentLocation.class)));
        Mockito.when((Object)this.muleApplicationNode.findMuleFlowNode("rootContainerName")).thenReturn(Optional.of((MuleFlowNode)Mockito.mock(MuleFlowNode.class)));
        method.invoke((Object)this.resolver, "aggregatorRef", this.muleApplicationNode, this.typingMuleAstVisitor, this.visitorContext);
        Assert.assertNotNull((Object)this.visitorContext);
    }

    @Test
    public void testResolveEventType() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = AggregatorListenerTypeResolver.class.getDeclaredMethod("resolveEventType", MessageProcessorNode.class, TypingMuleAstVisitor.class, TypingMuleAstVisitorContext.class);
        method.setAccessible(true);
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)((ComponentAst)Mockito.mock(ComponentAst.class)));
        method.invoke((Object)this.resolver, this.messageProcessorNode, this.typingMuleAstVisitor, this.visitorContext);
        Assert.assertNotNull((Object)this.visitorContext);
    }

    @Test
    public void testGetComponentModelType() {
        Optional result = this.resolver.getComponentModelType();
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)ComponentModelType.MESSAGE_SOURCE_NODE, result.get());
    }
}

