/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.phases.typing.resolver.GlobalBindingMetadataTypes;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class GlobalBindingMetadataTypesTest {
    @Mock
    private ExpressionLanguageMetadataService expressionLanguageMetadataService;
    @Mock
    private TypeLoader typeLoader;

    @Before
    public void setup() {
        Mockito.when((Object)this.expressionLanguageMetadataService.createTypeLoader(ArgumentMatchers.anyString(), (MetadataFormat)ArgumentMatchers.any(MetadataFormat.class))).thenReturn((Object)this.typeLoader);
        DefaultStringType stringType = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build();
        Mockito.when((Object)this.typeLoader.load(ArgumentMatchers.anyString())).thenReturn(Optional.of(stringType));
    }

    @Test
    public void testGetTypeFromJavaClass() {
        MetadataType stringType = GlobalBindingMetadataTypes.getTypeFromJavaClass((String)"java.lang.String");
        Assert.assertNotNull((Object)stringType);
        MetadataType integerType = GlobalBindingMetadataTypes.getTypeFromJavaClass((String)"java.lang.Integer");
        Assert.assertNotNull((Object)integerType);
    }

    @Test
    public void testCreateGlobalBindingMetadataTypes() {
        GlobalBindingMetadataTypes types = new GlobalBindingMetadataTypes(this.expressionLanguageMetadataService);
        Assert.assertNotNull((Object)types.correlationIdType());
        Assert.assertNotNull((Object)types.dataTypeType());
        Assert.assertNotNull((Object)types.authenticationType());
        Assert.assertNotNull((Object)types.itemSequenceInfoType());
        Assert.assertNotNull((Object)types.typedValueType());
        Assert.assertNotNull((Object)types.errorType());
    }

    @Test
    public void testStaticHolderClasses() {
        Assert.assertNotNull((Object)GlobalBindingMetadataTypes.getTypeFromJavaClass((String)"org.mule.runtime.api.metadata.DataType"));
        Assert.assertNotNull((Object)GlobalBindingMetadataTypes.getTypeFromJavaClass((String)"org.mule.runtime.api.security.Authentication"));
        Assert.assertNotNull((Object)GlobalBindingMetadataTypes.getTypeFromJavaClass((String)"org.mule.runtime.api.metadata.TypedValue"));
    }
}

