/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.TargetProcessingSupport;
import org.mule.datasense.impl.util.MessageCallbackFactory;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

public class TargetProcessingSupportTest {
    private TargetProcessingSupport targetProcessingSupport;
    private TypingMuleAstVisitorContext mockVisitorContext;
    private MessageCallbackFactory mockMessageCallbackFactory;
    private MuleEventMetadataType mockMuleEventMetadataType;
    private ExpressionLanguageMetadataService mockExpressionLanguageMetadataService;

    @Before
    public void setUp() {
        this.targetProcessingSupport = new TargetProcessingSupport();
        this.mockVisitorContext = (TypingMuleAstVisitorContext)Mockito.mock(TypingMuleAstVisitorContext.class);
        this.mockMessageCallbackFactory = (MessageCallbackFactory)Mockito.mock(MessageCallbackFactory.class);
        this.mockMuleEventMetadataType = (MuleEventMetadataType)Mockito.mock(MuleEventMetadataType.class);
        this.mockExpressionLanguageMetadataService = (ExpressionLanguageMetadataService)Mockito.mock(ExpressionLanguageMetadataService.class);
        Mockito.when((Object)this.mockVisitorContext.getExpressionLanguageMetadataService()).thenReturn((Object)this.mockExpressionLanguageMetadataService);
        Mockito.when((Object)this.mockMuleEventMetadataType.getVariables()).thenReturn((Object)((ObjectType)Mockito.mock(ObjectType.class)));
        Mockito.when((Object)this.mockMuleEventMetadataType.getMessageType()).thenReturn((Object)((MessageMetadataType)Mockito.mock(MessageMetadataType.class)));
        Mockito.when((Object)this.mockMuleEventMetadataType.getMessageType().getAttributesType()).thenReturn(Optional.of((MetadataType)Mockito.mock(MetadataType.class)));
        Mockito.when((Object)this.mockVisitorContext.getTypeBindings()).thenReturn((Object)new TypeBindings.Builder().addBinding("identifier1", (MetadataType)Mockito.mock(MetadataType.class)).build());
    }

    @Test
    public void testProcessTargetWithNullTargetAndMimeType() {
        EventType result = this.targetProcessingSupport.processTarget(null, null, null, this.mockMuleEventMetadataType, this.mockVisitorContext, this.mockMessageCallbackFactory);
        Assert.assertEquals((Object)TypeUtils.asEventType((MuleEventMetadataType)this.mockMuleEventMetadataType), (Object)result);
    }

    @Test
    public void testProcessTargetWithNullTarget() {
        EventType result = this.targetProcessingSupport.processTarget(null, null, "application/json", this.mockMuleEventMetadataType, this.mockVisitorContext, this.mockMessageCallbackFactory);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testProcessTargetWithTargetAndTargetValue() {
        EventType result = this.targetProcessingSupport.processTarget("myTarget", "myTargetValue", this.mockMuleEventMetadataType, this.mockVisitorContext, this.mockMessageCallbackFactory);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testProcessTargetWithEventType() {
        EventType mockEventType = (EventType)Mockito.mock(EventType.class);
        EventType result = this.targetProcessingSupport.processTarget("myTarget", "myTargetValue", mockEventType, this.mockVisitorContext, this.mockMessageCallbackFactory);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testProcessTargetWithMimeType() {
        EventType result = this.targetProcessingSupport.processTarget("myTarget", "myTargetValue", "application/json", this.mockMuleEventMetadataType, this.mockVisitorContext, this.mockMessageCallbackFactory);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testProcessTargetWithAttributes() {
        EventType result = this.targetProcessingSupport.processTarget(null, null, "application/json", this.mockMuleEventMetadataType, this.mockVisitorContext, this.mockMessageCallbackFactory);
        Assert.assertNotNull((Object)result);
    }
}

