/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.util.ComponentModelUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class ComponentModelUtilsTest {
    @Mock
    private MessageProcessorNode mockMessageProcessorNode;
    @Mock
    private ComponentAst mockComponentModel;
    @Mock
    private ComponentAst mockChildComponent1;
    @Mock
    private ComponentAst mockChildComponent2;
    @Mock
    private ComponentIdentifier mockComponentIdentifier;

    @Before
    public void setUp() {
        Mockito.when((Object)this.mockMessageProcessorNode.getComponentModel()).thenReturn((Object)this.mockComponentModel);
        Mockito.when((Object)this.mockComponentModel.directChildrenStream()).thenReturn(Stream.of(this.mockChildComponent1, this.mockChildComponent2));
    }

    @Test
    public void testCollectComponentModels_WithNullMessageProcessorNode() {
        Predicate<ComponentAst> predicate = c -> true;
        Optional result = ComponentModelUtils.collectComponentModels(null, predicate);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testCollectComponentModels_WithNullComponentModel() {
        Mockito.when((Object)this.mockMessageProcessorNode.getComponentModel()).thenReturn(null);
        Predicate<ComponentAst> predicate = c -> true;
        Optional result = ComponentModelUtils.collectComponentModels((MessageProcessorNode)this.mockMessageProcessorNode, predicate);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testCollectComponentModels_WithValidFilter() {
        Predicate<ComponentAst> filter = component -> component == this.mockChildComponent1;
        Optional result = ComponentModelUtils.collectComponentModels((MessageProcessorNode)this.mockMessageProcessorNode, filter);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((long)1L, (long)((Stream)result.get()).count());
    }

    @Test
    public void testCollectComponentModelsById_WithNullComponentIdentifier() {
        Optional result = ComponentModelUtils.collectComponentModelsById((MessageProcessorNode)this.mockMessageProcessorNode, null);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testCollectComponentModelsById_WithMatchingIdentifier() {
        Mockito.when((Object)this.mockChildComponent1.getIdentifier()).thenReturn((Object)this.mockComponentIdentifier);
        Mockito.when((Object)this.mockChildComponent2.getIdentifier()).thenReturn((Object)((ComponentIdentifier)Mockito.mock(ComponentIdentifier.class)));
        Optional result = ComponentModelUtils.collectComponentModelsById((MessageProcessorNode)this.mockMessageProcessorNode, (ComponentIdentifier)this.mockComponentIdentifier);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((long)1L, (long)((Stream)result.get()).count());
    }

    @Test
    public void testCollectComponentModelById() {
        Mockito.when((Object)this.mockChildComponent1.getIdentifier()).thenReturn((Object)this.mockComponentIdentifier);
        Mockito.when((Object)this.mockChildComponent2.getIdentifier()).thenReturn((Object)((ComponentIdentifier)Mockito.mock(ComponentIdentifier.class)));
        Optional result = ComponentModelUtils.collectComponentModelById((MessageProcessorNode)this.mockMessageProcessorNode, (ComponentIdentifier)this.mockComponentIdentifier);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)this.mockChildComponent1, result.get());
    }
}

