/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.munit;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.typing.resolver.munit.MUnitSetEventTypeResolver;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

public class MUnitSetEventTypeResolverTest {
    private MUnitSetEventTypeResolver resolver;
    private MessageProcessorNode messageProcessorNode;
    private ComponentAst componentModel;

    @Before
    public void setUp() {
        this.resolver = new MUnitSetEventTypeResolver();
        this.messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.componentModel = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)this.componentModel);
    }

    @Test
    public void testIsPropagatesTrue() {
        ComponentParameterAst parameterGroupModel = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)this.componentModel.getParameter(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)parameterGroupModel);
        Mockito.when((Object)parameterGroupModel.getValue()).thenReturn((Object)Either.right((Object)true));
        Assert.assertTrue((boolean)this.resolver.isPropagates(this.messageProcessorNode));
    }

    @Test
    public void testIsPropagatesFalse() {
        ComponentParameterAst parameterGroupModel = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)this.componentModel.getParameter(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)parameterGroupModel);
        Mockito.when((Object)parameterGroupModel.getValue()).thenReturn((Object)Either.right((Object)false));
        Assert.assertFalse((boolean)this.resolver.isPropagates(this.messageProcessorNode));
    }
}

