/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util;

import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.mule.datasense.impl.util.MetadataTypeReader;
import org.mule.datasense.impl.util.Parser;
import org.mule.datasense.impl.util.Parsers;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BooleanTypeBuilder;
import org.mule.metadata.api.builder.NumberTypeBuilder;
import org.mule.metadata.api.builder.StringTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.internal.utils.MetadataTypeWriter;

public class MetadataReaderTests {
    private <T> Parser<T> build(Parser<T> parser) {
        return Parsers.skip((Parser)Parsers.begin()).then(parser).skip(Parsers.end());
    }

    @Test
    public void parseBooleanType() throws Parsers.Failure {
        Assert.assertThat((Object)((TypeBuilder)this.build(MetadataTypeReader.parseBoolean).parse((CharSequence)"Boolean")), (Matcher)new IsInstanceOf(BooleanTypeBuilder.class));
    }

    @Test
    public void parseStringType() throws Parsers.Failure {
        Assert.assertThat((Object)((TypeBuilder)this.build(MetadataTypeReader.parseString).parse((CharSequence)"String")), (Matcher)new IsInstanceOf(StringTypeBuilder.class));
    }

    @Test
    public void parseNumberType() throws Parsers.Failure {
        Assert.assertThat((Object)((TypeBuilder)this.build(MetadataTypeReader.parseNumber).parse((CharSequence)"Number")), (Matcher)new IsInstanceOf(NumberTypeBuilder.class));
    }

    @Test
    public void parseBasicType() throws Parsers.Failure {
        Assert.assertThat((Object)((TypeBuilder)this.build(MetadataTypeReader.parseBasicType).parse((CharSequence)"Number")), (Matcher)new IsInstanceOf(NumberTypeBuilder.class));
        Assert.assertThat((Object)((TypeBuilder)this.build(MetadataTypeReader.parseBasicType).parse((CharSequence)"Boolean")), (Matcher)new IsInstanceOf(BooleanTypeBuilder.class));
        Assert.assertThat((Object)((TypeBuilder)this.build(MetadataTypeReader.parseBasicType).parse((CharSequence)"String")), (Matcher)new IsInstanceOf(StringTypeBuilder.class));
    }

    @Test
    public void parseWord() throws Parsers.Failure {
        Assert.assertEquals((Object)"Java", (Object)this.build(MetadataTypeReader.parseWord).parse((CharSequence)"Java"));
    }

    @Test
    public void parseHeader() throws Parsers.Failure {
        TypeBuilder result = (TypeBuilder)this.build(MetadataTypeReader.parseHeader).parse((CharSequence)"%type _: Otro");
    }

    @Test
    public void parseUnion() throws Parsers.Failure {
        String in = "Boolean | String | Number";
        TypeBuilder result = (TypeBuilder)this.build(MetadataTypeReader.parseUnion).parse((CharSequence)"Boolean | String | Number");
        System.out.println(new MetadataTypeWriter().toString(result.build()));
    }

    @Test
    public void parseIntersection() throws Parsers.Failure {
        String in = "Boolean & String & Number";
        TypeBuilder result = (TypeBuilder)this.build(MetadataTypeReader.parseIntersection).parse((CharSequence)"Boolean & String & Number");
        System.out.println(new MetadataTypeWriter().toString(result.build()));
    }

    @Test
    public void parseUnionOrBasic() throws Parsers.Failure {
        String in = "Boolean | String";
        TypeBuilder result = (TypeBuilder)this.build(MetadataTypeReader.parseUnion.or(MetadataTypeReader.parseBasicType)).parse((CharSequence)"Boolean | String");
        System.out.println(new MetadataTypeWriter().toString(result.build()));
    }

    @Test
    public void parseParenthesis() throws Parsers.Failure {
        String in = "(String | Number)";
        TypeBuilder result = (TypeBuilder)this.build(MetadataTypeReader.parseParenthesis).parse((CharSequence)"(String | Number)");
        System.out.println(new MetadataTypeWriter().toString(result.build()));
    }

    @Test
    public void parseArray() throws Parsers.Failure {
        String in = "[String | (Number)]";
        TypeBuilder result = (TypeBuilder)this.build(MetadataTypeReader.parseArray).parse((CharSequence)"[String | (Number)]");
        System.out.println(new MetadataTypeWriter().toString(result.build()));
    }

    @Test
    public void parseTuple() throws Parsers.Failure {
        String in = "<[String] | (Number & Number), String>";
        TypeBuilder result = (TypeBuilder)this.build(MetadataTypeReader.parseTuple).parse((CharSequence)"<[String] | (Number & Number), String>");
        System.out.println(new MetadataTypeWriter().toString(result.build()));
    }

    @Test
    public void parseType() throws Parsers.Failure {
        String in = "[[Number | String] | Number]";
        TypeBuilder result = (TypeBuilder)this.build(MetadataTypeReader.parseType).parse((CharSequence)"[[Number | String] | Number]");
        System.out.println(new MetadataTypeWriter().toString(result.build()));
    }

    @Test
    public void parseAnnotation() throws Parsers.Failure {
        String in = "@annotation(key:value, key:value)";
        TypeAnnotation parse = (TypeAnnotation)this.build(MetadataTypeReader.parseAnnotation).parse((CharSequence)"@annotation(key:value, key:value)");
        System.out.println();
    }

    @Test
    public void parseObject() throws Parsers.Failure {
        String in = "{ @annotation(key:value, key:value) key1: Number, key2: Boolean}";
        TypeBuilder result = (TypeBuilder)this.build(MetadataTypeReader.parseObject).parse((CharSequence)"{ @annotation(key:value, key:value) key1: Number, key2: Boolean}");
        System.out.println(new MetadataTypeWriter().toString(result.build()));
    }

    @Test
    public void parseMetadataType() throws Parsers.Failure {
        Parser parser = this.build(MetadataTypeReader.parseMetadataTypeDefinition);
        Assert.assertThat((Object)((TypeBuilder)parser.parse((CharSequence)"%type _: Java = Number")), (Matcher)new IsInstanceOf(NumberTypeBuilder.class));
        Assert.assertThat((Object)((TypeBuilder)parser.parse((CharSequence)"%type _: Java = Boolean")), (Matcher)new IsInstanceOf(BooleanTypeBuilder.class));
        Assert.assertThat((Object)((TypeBuilder)parser.parse((CharSequence)"%type _: Java = String")), (Matcher)new IsInstanceOf(StringTypeBuilder.class));
        Assert.assertThat((Object)((TypeBuilder)parser.parse((CharSequence)"%type _: Java = [String]")), (Matcher)new IsInstanceOf(ArrayTypeBuilder.class));
        Assert.assertThat((Object)((TypeBuilder)parser.parse((CharSequence)"%type _: Java = [String | Number]")), (Matcher)new IsInstanceOf(ArrayTypeBuilder.class));
        Assert.assertThat((Object)((TypeBuilder)parser.parse((CharSequence)"%type _: Java = [String | Number] | [String | Number]")), (Matcher)new IsInstanceOf(UnionTypeBuilder.class));
        Assert.assertThat((Object)((TypeBuilder)parser.parse((CharSequence)"%type _: Java = String | [Number | ([Boolean]) | String]")), (Matcher)new IsInstanceOf(UnionTypeBuilder.class));
    }
}

