/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.ast;

import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.mule.datasense.impl.model.annotations.FunctionBindingsAnnotation;
import org.mule.datasense.impl.model.annotations.GlobalBindingsAnnotation;
import org.mule.datasense.impl.model.annotations.MuleApplicationAnnotation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.VisitorContextAnnotation;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolverRegistry;
import org.mule.datasense.impl.util.AnnotationSupport;
import org.mule.datasense.impl.util.TreeLogSupport;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

public abstract class BaseAstNodeVisitorContext {
    private final TreeLogSupport treeLogSupport;
    private final AstNotification astNotification;
    private AnnotationSupport<VisitorContextAnnotation> annotationSupport;
    private TypeResolverRegistry typeResolverRegistry;
    private ExpressionLanguageMetadataService expressionLanguageMetadataService;

    public BaseAstNodeVisitorContext(AstNotification astNotification, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        this(null, astNotification, expressionLanguageMetadataService);
    }

    public BaseAstNodeVisitorContext(TypeResolverRegistry typeResolverRegistry, AstNotification astNotification, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        this.typeResolverRegistry = typeResolverRegistry;
        this.astNotification = astNotification;
        this.treeLogSupport = new TreeLogSupport();
        this.annotationSupport = new AnnotationSupport();
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
    }

    public ExpressionLanguageMetadataService getExpressionLanguageMetadataService() {
        return this.expressionLanguageMetadataService;
    }

    public TypeResolverRegistry getTypeResolverRegistry() {
        return this.typeResolverRegistry;
    }

    public AstNotification getAstNotification() {
        return this.astNotification;
    }

    public TreeLogSupport logger() {
        return this.treeLogSupport;
    }

    public Set<VisitorContextAnnotation> getAnnotations() {
        return this.annotationSupport.getAnnotations();
    }

    public <T extends VisitorContextAnnotation> Optional<T> getAnnotation(Class<T> annotationClass) {
        return this.annotationSupport.getAnnotation(annotationClass);
    }

    public <T extends VisitorContextAnnotation> void annotate(T annotation) {
        this.annotationSupport.annotate(annotation);
    }

    public <T extends VisitorContextAnnotation> Optional<T> deannotate(Class<T> annotation) {
        return this.annotationSupport.deannotate(annotation);
    }

    public <T extends VisitorContextAnnotation> boolean isAnnotatedWith(Class<T> annotationClass) {
        return this.annotationSupport.isAnnotatedWith(annotationClass);
    }

    public <T extends VisitorContextAnnotation> T getOrCreateAnnotation(Class<T> annotationClass, Supplier<T> supplier) {
        return (T)((VisitorContextAnnotation)this.annotationSupport.getOrCreateAnnotation(annotationClass, supplier));
    }

    public TypeBindings getTypeBindings() {
        TypeBindings.Builder result = TypeBindings.builder();
        this.getAnnotation(MuleApplicationAnnotation.class).map(MuleApplicationAnnotation::getMuleApplicationNode).ifPresent(muleApplicationNode -> {
            muleApplicationNode.getAnnotation(GlobalBindingsAnnotation.class).map(GlobalBindingsAnnotation::getTypeBindings).ifPresent(arg_0 -> ((TypeBindings.Builder)result).addAll(arg_0));
            muleApplicationNode.getAnnotation(FunctionBindingsAnnotation.class).map(FunctionBindingsAnnotation::getFunctionBindings).ifPresent(arg_0 -> ((TypeBindings.Builder)result).addAll(arg_0));
        });
        return result.build();
    }
}

