/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Collections;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.VarDecl;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.ForEachTypeResolver;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

public class ForEachTypeResolverImprovedTest {
    private ForEachTypeResolver resolver;
    private MessageProcessorNode messageProcessorNode;
    private ComponentAst componentModel;
    private TypingMuleAstVisitor typingMuleAstVisitor;
    private TypingMuleAstVisitorContext typingMuleAstVisitorContext;

    @Before
    public void setUp() {
        this.resolver = new ForEachTypeResolver();
        this.messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.componentModel = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.typingMuleAstVisitor = (TypingMuleAstVisitor)Mockito.mock(TypingMuleAstVisitor.class);
        this.typingMuleAstVisitorContext = (TypingMuleAstVisitorContext)Mockito.mock(TypingMuleAstVisitorContext.class);
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)this.componentModel);
    }

    @Test
    public void testIsBatchMode() {
        ConstructModel constructModel = (ConstructModel)Mockito.mock(ConstructModel.class);
        Mockito.when((Object)this.componentModel.getModel(ConstructModel.class)).thenReturn(Optional.of(constructModel));
        Mockito.when((Object)this.componentModel.getParameter("", "batchSize")).thenReturn((Object)((ComponentParameterAst)Mockito.mock(ComponentParameterAst.class)));
        Mockito.when((Object)this.componentModel.getParameter("", "batchSize").getValue()).thenReturn((Object)Either.right((Object)2));
        Mockito.when((Object)constructModel.getName()).thenReturn((Object)"constructModelName");
        Assert.assertFalse((boolean)ForEachTypeResolver.isBatchMode((ComponentAst)this.componentModel));
        Mockito.when((Object)this.componentModel.getParameter("", "batchSize").getValue()).thenReturn((Object)Either.right((Object)1));
        Assert.assertFalse((boolean)ForEachTypeResolver.isBatchMode((ComponentAst)this.componentModel));
    }

    @Test
    public void testBuildInnerPayloadType() {
        ArrayType arrayType = (ArrayType)Mockito.mock(ArrayType.class);
        MetadataType innerType = (MetadataType)Mockito.mock(MetadataType.class);
        Mockito.when((Object)arrayType.getType()).thenReturn((Object)innerType);
        Optional result = ForEachTypeResolver.buildInnerPayloadType((MetadataType)arrayType);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)innerType, result.get());
        ObjectType objectType = (ObjectType)Mockito.mock(ObjectType.class);
        Mockito.when((Object)objectType.getFields()).thenReturn(Collections.emptyList());
        result = ForEachTypeResolver.buildInnerPayloadType((MetadataType)objectType);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testResolve() {
        EventType inputEventType = (EventType)Mockito.mock(EventType.class);
        EventType outputEventType = this.resolver.resolve(this.messageProcessorNode, inputEventType, this.typingMuleAstVisitor, this.typingMuleAstVisitorContext);
        Assert.assertNotNull((Object)outputEventType);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.times((int)1))).annotate((AstNodeAnnotation)Mockito.any());
    }

    @Test
    public void testGetComponentModelType() {
        Optional result = this.resolver.getComponentModelType();
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)ComponentModelType.MESSAGE_PROCESSOR_NODE, result.get());
    }

    @Test
    public void testGetParseProvider() {
        Assert.assertTrue((boolean)this.resolver.getParseProvider().isPresent());
    }

    @Test
    public void testIsScope() {
        Assert.assertTrue((boolean)this.resolver.isScope());
    }

    @Test
    public void testForEachScopeInResolve() {
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)((ComponentAst)Mockito.mock(ComponentAst.class)));
        Mockito.when((Object)this.messageProcessorNode.getComponentModel().getParameter("General", "collection")).thenReturn((Object)((ComponentParameterAst)Mockito.mock(ComponentParameterAst.class)));
        Mockito.when((Object)this.messageProcessorNode.getComponentModel().getParameter("General", "collection").getValue()).thenReturn((Object)Either.right((Object)Mockito.mock(MetadataType.class)));
        ForEachTypeResolver.ForEachScopeIn scopeIn = new ForEachTypeResolver.ForEachScopeIn();
        EventType inputEventType = (EventType)Mockito.mock(EventType.class);
        ExpressionLanguageMetadataService service = (ExpressionLanguageMetadataService)Mockito.mock(ExpressionLanguageMetadataService.class);
        Mockito.when((Object)this.typingMuleAstVisitorContext.getExpressionLanguageMetadataService()).thenReturn((Object)service);
        Mockito.when((Object)service.getOutputType((TypeBindings)Mockito.any(), (String)Mockito.any(), (ExpressionLanguageMetadataService.MessageCallback)Mockito.any())).thenReturn((Object)((MetadataType)Mockito.mock(MetadataType.class)));
        Mockito.when((Object)inputEventType.get("#payload#")).thenReturn(Optional.of((VarDecl)Mockito.mock(VarDecl.class)));
        EventType outputEventType = scopeIn.resolve(this.messageProcessorNode, inputEventType, this.typingMuleAstVisitor, this.typingMuleAstVisitorContext);
        Assert.assertNotNull((Object)outputEventType);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.times((int)2))).annotate((AstNodeAnnotation)Mockito.any());
    }

    @Test
    public void testGetComponentIdentifierForeachScopeIn() {
        Assert.assertNotNull((Object)this.resolver.getComponentIdentifierForeachScopeIn());
    }
}

