/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.event;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.Optional;
import org.mule.datasense.impl.model.event.Expr;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

public class LiteralValueExpr
implements Expr {
    private final String value;
    private final String mimeType;

    public LiteralValueExpr(String value, String mimeType) {
        Preconditions.checkNotNull((Object)value);
        this.value = value;
        this.mimeType = mimeType;
    }

    private Optional<String> getMimeType() {
        return Optional.ofNullable(this.mimeType);
    }

    private boolean isMimeTypeApplicationJava(String mimeType) {
        for (String applicationJavaValidMimeType : MetadataFormats.JAVA.getValidMimeTypes()) {
            if (!mimeType.startsWith(applicationJavaValidMimeType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MetadataType resolveType(MuleEventMetadataType muleEventMetadataType, ResolveTypeContext resolveTypeContext) {
        DefaultStringType result;
        String mimeType = this.getMimeType().orElse(null);
        BaseTypeBuilder typeBuilder = TypesHelper.getTypeBuilder();
        if (mimeType == null || this.isMimeTypeApplicationJava(mimeType)) {
            result = typeBuilder.stringType().build();
        } else {
            ExpressionLanguageMetadataService expressionLanguageMetadataService = resolveTypeContext.getExpressionLanguageMetadataService();
            result = null;
            try {
                result = expressionLanguageMetadataService.getMetadataFromSample((InputStream)new ByteArrayInputStream(this.value.getBytes()), Collections.emptyMap(), (String)this.getMimeType().orElse(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                result = typeBuilder.anyType().build();
            }
        }
        return result;
    }

    @Override
    public void resolveInputType(MetadataType metadataType, MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder, ResolveTypeContext resolveTypeContext) {
    }
}

