/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.event;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.event.DefElemValueExpr;
import org.mule.datasense.impl.model.event.DefVariable;
import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;

public class DefVariableTest {
    private DefVariable defVariable;
    private DefElemValueExpr mockValue;
    private String validName;

    @Before
    public void setUp() {
        this.validName = "testVariable";
        this.mockValue = (DefElemValueExpr)Mockito.mock(DefElemValueExpr.class);
        this.defVariable = new DefVariable(this.validName, this.mockValue);
    }

    @Test
    public void testConstructorWithValidInputs() {
        Assert.assertNotNull((Object)this.defVariable);
    }

    @Test(expected=NullPointerException.class)
    public void testConstructorWithNullName() {
        new DefVariable(null, this.mockValue);
    }

    @Test(expected=IllegalStateException.class)
    public void testConstructorWithEmptyName() {
        new DefVariable("", this.mockValue);
    }

    @Test(expected=NullPointerException.class)
    public void testConstructorWithNullValue() {
        new DefVariable(this.validName, null);
    }

    @Test
    public void testResolveType() {
        MuleEventMetadataTypeBuilder mockBuilder = (MuleEventMetadataTypeBuilder)Mockito.mock(MuleEventMetadataTypeBuilder.class);
        MuleEventMetadataType mockEventType = (MuleEventMetadataType)Mockito.mock(MuleEventMetadataType.class);
        ResolveTypeContext mockContext = (ResolveTypeContext)Mockito.mock(ResolveTypeContext.class);
        MetadataType mockResolvedType = (MetadataType)Mockito.mock(MetadataType.class);
        Mockito.when((Object)this.mockValue.resolveType(mockEventType, mockContext)).thenReturn((Object)mockResolvedType);
        this.defVariable.resolveType(mockBuilder, mockEventType, mockContext);
        ((MuleEventMetadataTypeBuilder)Mockito.verify((Object)mockBuilder)).addVariable(this.validName, mockResolvedType);
        ((DefElemValueExpr)Mockito.verify((Object)this.mockValue)).resolveType(mockEventType, mockContext);
    }

    @Test
    public void testResolveInputTypeWithExistingVariable() {
        MuleEventMetadataTypeBuilder mockBuilder = (MuleEventMetadataTypeBuilder)Mockito.mock(MuleEventMetadataTypeBuilder.class);
        MuleEventMetadataType mockEventType = (MuleEventMetadataType)Mockito.mock(MuleEventMetadataType.class);
        ResolveTypeContext mockContext = (ResolveTypeContext)Mockito.mock(ResolveTypeContext.class);
        ObjectType mockVariables = (ObjectType)Mockito.mock(ObjectType.class);
        ObjectFieldType mockField = (ObjectFieldType)Mockito.mock(ObjectFieldType.class);
        MetadataType mockFieldType = (MetadataType)Mockito.mock(MetadataType.class);
        Mockito.when((Object)mockEventType.getVariables()).thenReturn((Object)mockVariables);
        Mockito.when((Object)mockVariables.getFieldByName(this.validName)).thenReturn(Optional.of(mockField));
        Mockito.when((Object)mockField.getValue()).thenReturn((Object)mockFieldType);
        this.defVariable.resolveInputType(mockBuilder, mockEventType, mockContext);
        ((DefElemValueExpr)Mockito.verify((Object)this.mockValue)).resolveInputType(mockBuilder, mockFieldType, mockContext);
    }

    @Test
    public void testResolveInputTypeWithNonExistingVariable() {
        MuleEventMetadataTypeBuilder mockBuilder = (MuleEventMetadataTypeBuilder)Mockito.mock(MuleEventMetadataTypeBuilder.class);
        MuleEventMetadataType mockEventType = (MuleEventMetadataType)Mockito.mock(MuleEventMetadataType.class);
        ResolveTypeContext mockContext = (ResolveTypeContext)Mockito.mock(ResolveTypeContext.class);
        ObjectType mockVariables = (ObjectType)Mockito.mock(ObjectType.class);
        Mockito.when((Object)mockEventType.getVariables()).thenReturn((Object)mockVariables);
        Mockito.when((Object)mockVariables.getFieldByName(this.validName)).thenReturn(Optional.empty());
        this.defVariable.resolveInputType(mockBuilder, mockEventType, mockContext);
        Assert.assertNotNull((Object)this.validName);
    }
}

