/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasense.impl.model.annotations.MuleApplicationAnnotation;
import org.mule.datasense.impl.model.annotations.munit.MUnitDeclarationsAnnotation;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.phases.annotators.Annotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.api.component.ComponentIdentifier;

public class MUnitDeclarationAnnotator
implements Annotator {
    @Override
    public void annotate(MuleFlowNode muleFlowNode, AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
        ComponentIdentifier componentIdentifier = muleFlowNode.getIdentifier();
        if (DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_BEFORE_TEST.equals(componentIdentifier)) {
            MUnitDeclarationsAnnotation mUnitDeclarationsAnnotation = this.getMUnitDeclarationsAnnotation(annotatingMuleAstVisitorContext);
            mUnitDeclarationsAnnotation.setBeforeTestMuleFlowNode(muleFlowNode);
        } else if (DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_AFTER_TEST.equals(componentIdentifier)) {
            MUnitDeclarationsAnnotation mUnitDeclarationsAnnotation = this.getMUnitDeclarationsAnnotation(annotatingMuleAstVisitorContext);
            mUnitDeclarationsAnnotation.setAfterTestMuleFlowNode(muleFlowNode);
        } else if (DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_BEFORE_SUITE.equals(componentIdentifier)) {
            MUnitDeclarationsAnnotation mUnitDeclarationsAnnotation = this.getMUnitDeclarationsAnnotation(annotatingMuleAstVisitorContext);
            mUnitDeclarationsAnnotation.setBeforeSuiteMuleFlowNode(muleFlowNode);
        } else if (DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_AFTER_SUITE.equals(componentIdentifier)) {
            MUnitDeclarationsAnnotation mUnitDeclarationsAnnotation = this.getMUnitDeclarationsAnnotation(annotatingMuleAstVisitorContext);
            mUnitDeclarationsAnnotation.setAfterSuiteMuleFlowNode(muleFlowNode);
        }
    }

    private MUnitDeclarationsAnnotation getMUnitDeclarationsAnnotation(AnnotatingMuleAstVisitorContext visitorContext) {
        MuleApplicationNode muleApplicationNode = visitorContext.getAnnotation(MuleApplicationAnnotation.class).map(MuleApplicationAnnotation::getMuleApplicationNode).orElseThrow(() -> new IllegalArgumentException("Mule application node not set."));
        return (MUnitDeclarationsAnnotation)muleApplicationNode.getOrCreateAnnotation(MUnitDeclarationsAnnotation.class, MUnitDeclarationsAnnotation::new);
    }
}

