/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.MuleFlowAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.MessageProcessorNodeBuilder;
import org.mule.datasense.impl.phases.builder.MuleAstParseProvider;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.FlowTypeResolver;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ComponentAst;

public class FlowTypeResolverTest {
    private FlowTypeResolver flowTypeResolver;
    private FlowTypeResolver.ScopeIn scopeIn;
    private FlowTypeResolver.ScopeOut scopeOut;
    private MessageProcessorNode mockNode;
    private EventType mockEventType;
    private TypingMuleAstVisitor mockVisitor;
    private TypingMuleAstVisitorContext mockContext;

    @Before
    public void setUp() {
        this.flowTypeResolver = new FlowTypeResolver();
        this.scopeIn = new FlowTypeResolver.ScopeIn();
        this.scopeOut = new FlowTypeResolver.ScopeOut();
        this.mockNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.mockEventType = (EventType)Mockito.mock(EventType.class);
        this.mockVisitor = (TypingMuleAstVisitor)Mockito.mock(TypingMuleAstVisitor.class);
        this.mockContext = (TypingMuleAstVisitorContext)Mockito.mock(TypingMuleAstVisitorContext.class);
    }

    @Test
    public void testGetComponentModelType() {
        Optional result = this.flowTypeResolver.getComponentModelType();
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)ComponentModelType.MESSAGE_PROCESSOR_NODE, result.get());
    }

    @Test
    public void testGetParseProvider() {
        Optional result = this.flowTypeResolver.getParseProvider();
        Assert.assertTrue((boolean)result.isPresent());
    }

    @Test
    public void testGetScopeInMessageProcessorNode() {
        MessageProcessorNode mockNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        MessageProcessorNode mockChildNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Mockito.when((Object)mockNode.getMessageProcessorNodes()).thenReturn(Stream.of(mockChildNode));
        Mockito.when((Object)mockChildNode.getComponentIdentifier()).thenReturn((Object)DefaultDataSense.COMPONENT_IDENTIFIER_FLOW_SCOPE_IN);
        Optional result = FlowTypeResolver.getScopeInMessageProcessorNode((MessageProcessorNode)mockNode);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)mockChildNode, result.get());
    }

    @Test
    public void testGetScopeOutMessageProcessorNode() {
        MessageProcessorNode mockNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        MessageProcessorNode mockChildNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Mockito.when((Object)mockNode.getMessageProcessorNodes()).thenReturn(Stream.of(mockChildNode));
        Mockito.when((Object)mockChildNode.getComponentIdentifier()).thenReturn((Object)DefaultDataSense.COMPONENT_IDENTIFIER_FLOW_SCOPE_OUT);
        Optional result = FlowTypeResolver.getScopeOutMessageProcessorNode((MessageProcessorNode)mockNode);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)mockChildNode, result.get());
    }

    @Test
    public void testGenerateAst() {
        ComponentIdentifier mockIdentifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        ComponentAst mockComponentModel = (ComponentAst)Mockito.mock(ComponentAst.class);
        ComponentModelType mockComponentModelType = ComponentModelType.MESSAGE_PROCESSOR_NODE;
        ArrayList mockBuilders = new ArrayList();
        Optional parseProvider = this.flowTypeResolver.getParseProvider();
        Assert.assertTrue((boolean)parseProvider.isPresent());
        MuleAstParseProvider provider = (MuleAstParseProvider)parseProvider.get();
        Optional result = provider.parse(mockIdentifier, mockComponentModel, mockComponentModelType, mockBuilders, null);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertTrue((boolean)(result.get() instanceof MessageProcessorNodeBuilder));
    }

    @Test
    public void testScopeInResolve() {
        MuleFlowAnnotation mockFlowAnnotation = (MuleFlowAnnotation)Mockito.mock(MuleFlowAnnotation.class);
        MuleFlowNode muleFlowNode = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        UsesTypeAnnotation mockUsesTypeAnnotation = (UsesTypeAnnotation)Mockito.mock(UsesTypeAnnotation.class);
        EventType mockUsesEventType = (EventType)Mockito.mock(EventType.class);
        Mockito.when((Object)this.mockContext.getAnnotation(MuleFlowAnnotation.class)).thenReturn(Optional.of(mockFlowAnnotation));
        Mockito.when((Object)mockFlowAnnotation.getMuleFlowNode()).thenReturn((Object)muleFlowNode);
        Mockito.when((Object)muleFlowNode.getAnnotation(UsesTypeAnnotation.class)).thenReturn(Optional.of(mockUsesTypeAnnotation));
        Mockito.when((Object)mockUsesTypeAnnotation.getUsesEventType()).thenReturn((Object)mockUsesEventType);
        EventType result = this.scopeIn.resolve(this.mockNode, this.mockEventType, this.mockVisitor, this.mockContext);
        Assert.assertEquals((Object)mockUsesEventType, (Object)result);
        ((MessageProcessorNode)Mockito.verify((Object)this.mockNode)).annotate((AstNodeAnnotation)((DefinesTypeAnnotation)Mockito.any(DefinesTypeAnnotation.class)));
    }

    @Test
    public void testScopeInResolveFallback() {
        Mockito.when((Object)this.mockContext.getAnnotation(MuleFlowAnnotation.class)).thenReturn(Optional.empty());
        EventType result = this.scopeIn.resolve(this.mockNode, this.mockEventType, this.mockVisitor, this.mockContext);
        Assert.assertEquals((Object)this.mockEventType, (Object)result);
        ((MessageProcessorNode)Mockito.verify((Object)this.mockNode)).annotate((AstNodeAnnotation)((DefinesTypeAnnotation)Mockito.any(DefinesTypeAnnotation.class)));
    }

    @Test
    public void testScopeOutResolve() {
        MuleFlowAnnotation mockFlowAnnotation = (MuleFlowAnnotation)Mockito.mock(MuleFlowAnnotation.class);
        MuleFlowNode muleFlowNode = (MuleFlowNode)Mockito.mock(MuleFlowNode.class);
        DefinesTypeAnnotation mockDefinesTypeAnnotation = (DefinesTypeAnnotation)Mockito.mock(DefinesTypeAnnotation.class);
        EventType mockDefinesEventType = (EventType)Mockito.mock(EventType.class);
        Mockito.when((Object)this.mockContext.getAnnotation(MuleFlowAnnotation.class)).thenReturn(Optional.of(mockFlowAnnotation));
        Mockito.when((Object)mockFlowAnnotation.getMuleFlowNode()).thenReturn((Object)muleFlowNode);
        Mockito.when((Object)muleFlowNode.getAnnotation(DefinesTypeAnnotation.class)).thenReturn(Optional.of(mockDefinesTypeAnnotation));
        Mockito.when((Object)mockDefinesTypeAnnotation.getDefinesEventType()).thenReturn((Object)mockDefinesEventType);
        EventType result = this.scopeOut.resolve(this.mockNode, this.mockEventType, this.mockVisitor, this.mockContext);
        Assert.assertEquals((Object)this.mockEventType, (Object)result);
        ((MessageProcessorNode)Mockito.verify((Object)this.mockNode)).annotate((AstNodeAnnotation)((UsesTypeAnnotation)Mockito.any(UsesTypeAnnotation.class)));
    }

    @Test
    public void testScopeOutResolveFallback() {
        Mockito.when((Object)this.mockContext.getAnnotation(MuleFlowAnnotation.class)).thenReturn(Optional.empty());
        EventType result = this.scopeOut.resolve(this.mockNode, this.mockEventType, this.mockVisitor, this.mockContext);
        Assert.assertEquals((Object)this.mockEventType, (Object)result);
        ((MessageProcessorNode)Mockito.verify((Object)this.mockNode)).annotate((AstNodeAnnotation)((UsesTypeAnnotation)Mockito.any(UsesTypeAnnotation.class)));
    }

    @Test
    public void testScopeInIsPropagates() {
        Assert.assertTrue((boolean)this.scopeIn.isPropagates(this.mockNode));
    }

    @Test
    public void testScopeOutIsPropagates() {
        Assert.assertTrue((boolean)this.scopeOut.isPropagates(this.mockNode));
    }
}

