/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.builder;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.phases.builder.ComponentResolutionScopeStrategy;
import org.mule.datasenseapi.api.ComponentResolutionScope;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.ast.api.ComponentAst;

@RunWith(value=MockitoJUnitRunner.class)
public class ComponentResolutionScopeStrategyTest {
    @Mock
    private ComponentAst mockComponent;
    @Mock
    private ComponentLocation mockComponentLocation;
    private Location scopeLocation;

    @Before
    public void setup() {
        this.scopeLocation = Location.builder().globalName("test-flow").build();
    }

    @Test
    public void testMatchReturnsFalseWhenLocationIsNull() {
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testMatchReturnsFalseWhenGlobalNamesDoNotMatch() {
        Mockito.when((Object)this.mockComponent.getLocation()).thenReturn((Object)this.mockComponentLocation);
        Mockito.when((Object)this.mockComponentLocation.getLocation()).thenReturn((Object)"other-flow/processors/0");
        ComponentResolutionScope scope = new ComponentResolutionScope(this.scopeLocation);
        ComponentResolutionScopeStrategy strategy = new ComponentResolutionScopeStrategy(scope);
        Assert.assertFalse((boolean)strategy.match(this.mockComponent));
    }

    @Test
    public void testMatchReturnsTrueWhenGlobalNamesMatch() {
        Mockito.when((Object)this.mockComponent.getLocation()).thenReturn((Object)this.mockComponentLocation);
        Mockito.when((Object)this.mockComponentLocation.getLocation()).thenReturn((Object)"test-flow/processors/0");
        ComponentResolutionScope scope = new ComponentResolutionScope(this.scopeLocation);
        ComponentResolutionScopeStrategy strategy = new ComponentResolutionScopeStrategy(scope);
        Assert.assertTrue((boolean)strategy.match(this.mockComponent));
    }
}

