/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.ast;

import java.util.Optional;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.datasense.impl.model.annotations.FunctionBindingsAnnotation;
import org.mule.datasense.impl.model.annotations.GlobalBindingsAnnotation;
import org.mule.datasense.impl.model.annotations.MuleApplicationAnnotation;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.BaseAstNodeVisitorContext;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.VisitorContextAnnotation;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolverRegistry;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

public class BaseAstNodeVisitorContextTest {
    @Mock
    private AstNotification mockAstNotification;
    @Mock
    private ExpressionLanguageMetadataService mockExpressionLanguageMetadataService;
    @Mock
    private TypeResolverRegistry mockTypeResolverRegistry;
    private TestBaseAstNodeVisitorContext context;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.context = new TestBaseAstNodeVisitorContext(this.mockTypeResolverRegistry, this.mockAstNotification, this.mockExpressionLanguageMetadataService);
    }

    @Test
    public void testConstructorWithoutTypeResolverRegistry() {
        TestBaseAstNodeVisitorContext contextWithoutRegistry = new TestBaseAstNodeVisitorContext(this.mockAstNotification, this.mockExpressionLanguageMetadataService);
        Assert.assertNull((Object)contextWithoutRegistry.getTypeResolverRegistry());
        Assert.assertNotNull((Object)contextWithoutRegistry.getAstNotification());
        Assert.assertNotNull((Object)contextWithoutRegistry.getExpressionLanguageMetadataService());
    }

    @Test
    public void testConstructorWithTypeResolverRegistry() {
        Assert.assertNotNull((Object)this.context.getTypeResolverRegistry());
        Assert.assertNotNull((Object)this.context.getAstNotification());
        Assert.assertNotNull((Object)this.context.getExpressionLanguageMetadataService());
    }

    @Test
    public void testLogger() {
        Assert.assertNotNull((Object)this.context.logger());
    }

    @Test
    public void testAnnotations() {
        TestAnnotation testAnnotation = new TestAnnotation();
        this.context.annotate(testAnnotation);
        Set annotations = this.context.getAnnotations();
        Assert.assertTrue((boolean)annotations.contains(testAnnotation));
        Optional retrievedAnnotation = this.context.getAnnotation(TestAnnotation.class);
        Assert.assertTrue((boolean)retrievedAnnotation.isPresent());
        Assert.assertEquals((Object)testAnnotation, retrievedAnnotation.get());
        Assert.assertTrue((boolean)this.context.isAnnotatedWith(TestAnnotation.class));
        Optional deannotated = this.context.deannotate(TestAnnotation.class);
        Assert.assertTrue((boolean)deannotated.isPresent());
        Assert.assertEquals((Object)testAnnotation, deannotated.get());
        Assert.assertFalse((boolean)this.context.isAnnotatedWith(TestAnnotation.class));
    }

    @Test
    public void testGetOrCreateAnnotation() {
        TestAnnotation createdAnnotation = (TestAnnotation)this.context.getOrCreateAnnotation(TestAnnotation.class, () -> new TestAnnotation());
        Assert.assertNotNull((Object)createdAnnotation);
        TestAnnotation retrievedAnnotation = (TestAnnotation)this.context.getOrCreateAnnotation(TestAnnotation.class, () -> new TestAnnotation());
        Assert.assertEquals((Object)createdAnnotation, (Object)retrievedAnnotation);
    }

    @Test
    public void testGetTypeBindings() {
        MuleApplicationAnnotation mockMuleAppAnnotation = (MuleApplicationAnnotation)Mockito.mock(MuleApplicationAnnotation.class);
        AstNode mockMuleAppNode = (AstNode)Mockito.mock(AstNode.class);
        GlobalBindingsAnnotation mockGlobalBindings = (GlobalBindingsAnnotation)Mockito.mock(GlobalBindingsAnnotation.class);
        FunctionBindingsAnnotation mockFunctionBindings = (FunctionBindingsAnnotation)Mockito.mock(FunctionBindingsAnnotation.class);
        TypeBindings mockGlobalTypeBindings = (TypeBindings)Mockito.mock(TypeBindings.class);
        TypeBindings mockFunctionTypeBindings = (TypeBindings)Mockito.mock(TypeBindings.class);
        Mockito.when((Object)mockMuleAppAnnotation.getMuleApplicationNode()).thenReturn((Object)((MuleApplicationNode)Mockito.mock(MuleApplicationNode.class)));
        Mockito.when((Object)mockMuleAppNode.getAnnotation(GlobalBindingsAnnotation.class)).thenReturn(Optional.of(mockGlobalBindings));
        Mockito.when((Object)mockMuleAppNode.getAnnotation(FunctionBindingsAnnotation.class)).thenReturn(Optional.of(mockFunctionBindings));
        Mockito.when((Object)mockGlobalBindings.getTypeBindings()).thenReturn((Object)mockGlobalTypeBindings);
        Mockito.when((Object)mockFunctionBindings.getFunctionBindings()).thenReturn((Object)mockFunctionTypeBindings);
        this.context.annotate((VisitorContextAnnotation)mockMuleAppAnnotation);
        TypeBindings result = this.context.getTypeBindings();
        Assert.assertNotNull((Object)result);
    }

    private static class TestBaseAstNodeVisitorContext
    extends BaseAstNodeVisitorContext {
        public TestBaseAstNodeVisitorContext(AstNotification astNotification, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
            super(astNotification, expressionLanguageMetadataService);
        }

        public TestBaseAstNodeVisitorContext(TypeResolverRegistry typeResolverRegistry, AstNotification astNotification, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
            super(typeResolverRegistry, astNotification, expressionLanguageMetadataService);
        }
    }

    private static class TestAnnotation
    implements VisitorContextAnnotation {
        private TestAnnotation() {
        }
    }
}

