/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.batch;

import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.VarDecl;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.batch.BatchAggregatorTypeResolver;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

public class BatchAggregatorTypeResolverTest {
    private BatchAggregatorTypeResolver resolver;
    private ComponentIdentifier scopeInIdentifier;
    private ComponentIdentifier scopeOutIdentifier;
    private BatchAggregatorTypeResolver.ScopeIn scopeIn;

    @Before
    public void setUp() {
        this.scopeInIdentifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        this.scopeOutIdentifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        this.resolver = new BatchAggregatorTypeResolver(this.scopeInIdentifier, this.scopeOutIdentifier);
        this.scopeIn = new BatchAggregatorTypeResolver.ScopeIn();
    }

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)this.resolver);
    }

    @Test
    public void testIsPropagates() {
        MessageProcessorNode node = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Assert.assertTrue((boolean)this.resolver.isPropagates(node));
    }

    @Test
    public void testScopeInResolve() {
        MetadataType metadataType = (MetadataType)Mockito.mock(MetadataType.class);
        EventType inputEventType = new EventType(Collections.singletonList(new VarDecl("input", metadataType)).stream());
        EventType outputEventType = new EventType(Collections.singletonList(new VarDecl("output", metadataType)).stream());
        MessageProcessorNode messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        TypingMuleAstVisitor typingMuleAstVisitor = (TypingMuleAstVisitor)Mockito.mock(TypingMuleAstVisitor.class);
        TypingMuleAstVisitorContext typingMuleAstVisitorContext = (TypingMuleAstVisitorContext)Mockito.mock(TypingMuleAstVisitorContext.class);
        MessageProcessorNode childNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Mockito.when((Object)messageProcessorNode.getMessageProcessorNodes()).thenReturn(Stream.of(childNode));
        Mockito.when((Object)typingMuleAstVisitor.resolveType((AstNode)childNode, inputEventType, typingMuleAstVisitorContext)).thenReturn((Object)outputEventType);
        Mockito.when((Object)messageProcessorNode.getComponentModel()).thenReturn((Object)((ComponentAst)Mockito.mock(ComponentAst.class)));
        ComponentParameterAst componentParameterAst = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)messageProcessorNode.getComponentModel().getParameter(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)componentParameterAst);
        Mockito.when((Object)componentParameterAst.getValue()).thenReturn((Object)Either.right((Object)true));
        Mockito.when((Object)metadataType.getMetadataFormat()).thenReturn((Object)((MetadataFormat)Mockito.mock(MetadataFormat.class)));
        Mockito.when((Object)metadataType.getMetadataFormat().getLabel()).thenReturn(Optional.of("abc"));
        EventType result = this.scopeIn.resolve(messageProcessorNode, inputEventType, typingMuleAstVisitor, typingMuleAstVisitorContext);
        Assert.assertNotEquals((Object)outputEventType, (Object)result);
    }
}

