/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.datasense.extension.DataSenseModuleRegistry;
import org.mule.datasense.impl.DataSenseApplicationModel;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.phases.typing.resolver.DataSenseTypeResolverRegistry;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolverRegistry;
import org.mule.datasense.impl.tooling.MetadataQuery;
import org.mule.datasense.impl.tooling.MetadataQueryResult;
import org.mule.datasense.impl.tooling.TypedApplicationQuery;
import org.mule.datasense.impl.util.LocationUtils;
import org.mule.datasenseapi.api.AnalysisResult;
import org.mule.datasenseapi.api.ApplicationResolutionScope;
import org.mule.datasenseapi.api.ComponentResolutionScope;
import org.mule.datasenseapi.api.DataSenseInfo;
import org.mule.datasenseapi.api.DataSenseResolutionScope;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.ast.api.ArtifactAst;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class DefaultDataSenseTest {
    @Mock
    private DataSenseModuleRegistry mockDataSenseModuleRegistry;
    @Mock
    private ApplicationModel mockApplicationModel;
    @Mock
    private DataSenseProvider mockDataSenseProvider;
    @Mock
    private ApplicationResolutionScope mockApplicationResolutionScope;
    @Mock
    private ComponentResolutionScope mockComponentResolutionScope;
    @Mock
    private Location mockLocation;
    @Mock
    private AstNotification mockAstNotification;
    @Mock
    private MuleApplicationNode mockMuleApplicationNode;
    @Mock
    private DataSenseProviderResolver mockDataSenseProviderResolver;
    @Mock
    private DataSenseTypeResolverRegistry mockTypeResolverRegistry;
    @Mock
    private DataSenseApplicationModel mockDataSenseApplicationModel;
    @Mock
    private ExpressionLanguageMetadataService mockExpressionLanguageMetadataService;
    private DefaultDataSense defaultDataSense;

    @Before
    public void setUp() throws Exception {
        this.defaultDataSense = (DefaultDataSense)Mockito.spy((Object)new DefaultDataSense());
        Field field = DefaultDataSense.class.getDeclaredField("dataSenseModuleRegistry");
        field.setAccessible(true);
        field.set(this.defaultDataSense, this.mockDataSenseModuleRegistry);
        Mockito.when((Object)this.mockDataSenseProvider.getExpressionLanguageMetadataService()).thenReturn((Object)this.mockExpressionLanguageMetadataService);
        Mockito.when((Object)this.mockDataSenseProviderResolver.getExpressionLanguageMetadataService()).thenReturn((Object)this.mockExpressionLanguageMetadataService);
        TypeLoader mockTypeLoader = (TypeLoader)Mockito.mock(TypeLoader.class);
        MetadataType mockMetadataType = (MetadataType)Mockito.mock(MetadataType.class);
        Mockito.when((Object)mockTypeLoader.load((String)ArgumentMatchers.any(String.class))).thenReturn(Optional.of(mockMetadataType));
        Mockito.when((Object)this.mockExpressionLanguageMetadataService.createTypeLoader((String)ArgumentMatchers.any(String.class), (MetadataFormat)ArgumentMatchers.any(MetadataFormat.class))).thenReturn((Object)mockTypeLoader);
    }

    @Test
    public void testGetLogger() {
        Assert.assertNotNull((Object)DefaultDataSense.getLogger());
    }

    @Test
    public void testCreateTypeResolverRegistry() throws Exception {
        Method method = DefaultDataSense.class.getDeclaredMethod("createTypeResolverRegistry", new Class[0]);
        method.setAccessible(true);
        TypeResolverRegistry result = (TypeResolverRegistry)method.invoke((Object)this.defaultDataSense, new Object[0]);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof DataSenseTypeResolverRegistry));
    }

    @Test
    public void testResolveWithLocation() {
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testResolveWithResolutionScope() {
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testAnalyze() {
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testPerform() throws Exception {
        Method method = DefaultDataSense.class.getDeclaredMethod("perform", TypedApplicationQuery.class, MuleApplicationNode.class, DataSenseProviderResolver.class, AstNotification.class);
        method.setAccessible(true);
        TypedApplicationQuery mockQuery = (TypedApplicationQuery)Mockito.mock(TypedApplicationQuery.class);
        Optional result = (Optional)method.invoke((Object)this.defaultDataSense, mockQuery, this.mockMuleApplicationNode, this.mockDataSenseProviderResolver, this.mockAstNotification);
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testPerformWithMetadataQuery() throws Exception {
        Method method = DefaultDataSense.class.getDeclaredMethod("perform", TypedApplicationQuery.class, MuleApplicationNode.class, DataSenseProviderResolver.class, AstNotification.class);
        method.setAccessible(true);
        MetadataQuery mockMetadataQuery = (MetadataQuery)Mockito.mock(MetadataQuery.class);
        MetadataQueryResult mockResult = (MetadataQueryResult)Mockito.mock(MetadataQueryResult.class);
        Mockito.when((Object)mockMetadataQuery.perform(this.mockMuleApplicationNode, this.mockDataSenseProviderResolver, this.mockAstNotification)).thenReturn(Optional.of(mockResult));
        Optional result = (Optional)method.invoke((Object)this.defaultDataSense, mockMetadataQuery, this.mockMuleApplicationNode, this.mockDataSenseProviderResolver, this.mockAstNotification);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)mockResult, result.get());
    }

    @Test
    public void testResolveLocationDelegatesToComponentResolutionScope() {
        DefaultDataSense spyDataSense = (DefaultDataSense)Mockito.spy((Object)new DefaultDataSense());
        DataSenseProvider mockProvider = (DataSenseProvider)Mockito.mock(DataSenseProvider.class);
        ApplicationModel mockAppModel = (ApplicationModel)Mockito.mock(ApplicationModel.class);
        Location mockLocation = (Location)Mockito.mock(Location.class);
        ComponentResolutionScope scope = new ComponentResolutionScope(mockLocation);
        ((DefaultDataSense)Mockito.doReturn(Optional.of((DataSenseInfo)Mockito.mock(DataSenseInfo.class))).when((Object)spyDataSense)).resolve((DataSenseResolutionScope)ArgumentMatchers.any(DataSenseResolutionScope.class), (ApplicationModel)ArgumentMatchers.eq((Object)mockAppModel), (DataSenseProvider)ArgumentMatchers.eq((Object)mockProvider));
        Optional result = spyDataSense.resolve(mockLocation, mockAppModel, mockProvider);
        Assert.assertTrue((boolean)result.isPresent());
        ((DefaultDataSense)Mockito.verify((Object)spyDataSense)).resolve((DataSenseResolutionScope)ArgumentMatchers.any(DataSenseResolutionScope.class), (ApplicationModel)ArgumentMatchers.eq((Object)mockAppModel), (DataSenseProvider)ArgumentMatchers.eq((Object)mockProvider));
    }

    public void testResolveWithComponentResolutionScopeAndLocationIsFlow() {
        DefaultDataSense spyDataSense = (DefaultDataSense)Mockito.spy((Object)new DefaultDataSense());
        DataSenseProvider mockProvider = (DataSenseProvider)Mockito.mock(DataSenseProvider.class);
        ApplicationModel mockAppModel = (ApplicationModel)Mockito.mock(ApplicationModel.class);
        Location mockLocation = (Location)Mockito.mock(Location.class);
        ComponentResolutionScope scope = new ComponentResolutionScope(mockLocation);
        ArtifactAst mockArtifactAst = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        Mockito.when((Object)mockAppModel.getMuleApplicationModel()).thenReturn((Object)mockArtifactAst);
        Mockito.when((Object)mockArtifactAst.topLevelComponentsStream()).thenAnswer(invocation -> Stream.empty());
        Mockito.when((Object)mockProvider.getExpressionLanguageMetadataService()).thenReturn((Object)this.mockExpressionLanguageMetadataService);
        try (MockedStatic utilities = Mockito.mockStatic(LocationUtils.class);){
            utilities.when(() -> LocationUtils.isFlow((Location)mockLocation)).thenReturn((Object)true);
            Optional result = spyDataSense.resolve((DataSenseResolutionScope)scope, mockAppModel, mockProvider);
            Assert.assertNotNull((Object)result);
        }
    }

    public void testResolveWithComponentResolutionScopeAndLocationIsNotFlow() {
        DefaultDataSense spyDataSense = (DefaultDataSense)Mockito.spy((Object)new DefaultDataSense());
        DataSenseProvider mockProvider = (DataSenseProvider)Mockito.mock(DataSenseProvider.class);
        ApplicationModel mockAppModel = (ApplicationModel)Mockito.mock(ApplicationModel.class);
        Location mockLocation = (Location)Mockito.mock(Location.class);
        ComponentResolutionScope scope = new ComponentResolutionScope(mockLocation);
        ArtifactAst mockArtifactAst = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        Mockito.when((Object)mockAppModel.getMuleApplicationModel()).thenReturn((Object)mockArtifactAst);
        Mockito.when((Object)mockArtifactAst.topLevelComponentsStream()).thenAnswer(invocation -> Stream.empty());
        Mockito.when((Object)mockProvider.getExpressionLanguageMetadataService()).thenReturn((Object)this.mockExpressionLanguageMetadataService);
        try (MockedStatic utilities = Mockito.mockStatic(LocationUtils.class);){
            utilities.when(() -> LocationUtils.isFlow((Location)mockLocation)).thenReturn((Object)false);
            Optional result = spyDataSense.resolve((DataSenseResolutionScope)scope, mockAppModel, mockProvider);
            Assert.assertNotNull((Object)result);
        }
    }

    @Test
    public void testAnalyzeReturnsAnalysisResult() {
        DefaultDataSense spyDataSense = (DefaultDataSense)Mockito.spy((Object)new DefaultDataSense());
        DataSenseProvider mockProvider = (DataSenseProvider)Mockito.mock(DataSenseProvider.class);
        ApplicationModel mockAppModel = (ApplicationModel)Mockito.mock(ApplicationModel.class);
        AnalysisResult mockResult = (AnalysisResult)Mockito.mock(AnalysisResult.class);
        Mockito.when((Object)mockProvider.getExpressionLanguageMetadataService()).thenReturn((Object)this.mockExpressionLanguageMetadataService);
        try {
            Method analyzeMethod = DefaultDataSense.class.getDeclaredMethod("analyze", DataSenseProvider.class, ApplicationModel.class);
            analyzeMethod.setAccessible(true);
            Object result = analyzeMethod.invoke((Object)spyDataSense, mockProvider, mockAppModel);
            Assert.assertTrue((result == null || result instanceof AnalysisResult ? 1 : 0) != 0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testResolveWithNullsAndEdgeCases() {
        DefaultDataSense spyDataSense = (DefaultDataSense)Mockito.spy((Object)new DefaultDataSense());
        DataSenseProvider mockProvider = (DataSenseProvider)Mockito.mock(DataSenseProvider.class);
        ApplicationModel mockAppModel = (ApplicationModel)Mockito.mock(ApplicationModel.class);
        Location mockLocation = (Location)Mockito.mock(Location.class);
        ComponentResolutionScope scope = new ComponentResolutionScope(mockLocation);
        ArtifactAst mockArtifactAst = (ArtifactAst)Mockito.mock(ArtifactAst.class);
        Mockito.when((Object)mockAppModel.getMuleApplicationModel()).thenReturn((Object)mockArtifactAst);
        Mockito.when((Object)mockArtifactAst.topLevelComponentsStream()).thenAnswer(invocation -> Stream.empty());
        Mockito.when((Object)mockProvider.getExpressionLanguageMetadataService()).thenReturn((Object)this.mockExpressionLanguageMetadataService);
        Optional result = spyDataSense.resolve((DataSenseResolutionScope)scope, mockAppModel, mockProvider);
        Assert.assertNotNull((Object)result);
    }
}

