/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.types;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.model.types.VarDecl;
import org.mule.datasense.impl.model.types.VarDeclMetadata;
import org.mule.datasense.impl.util.matchers.MetadataTypeMatcher;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.model.impl.DefaultTypeParameterType;
import org.mule.metadata.message.api.LocationAnnotation;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

public class TypeUtilsTest {
    @Test
    public void nullsSimplificationOnNonUnionTypeReturnsSameType() {
        BinaryType metadataType = TypesHelper.getTypeBuilder().binaryType().build();
        Assert.assertEquals((Object)TypeUtils.removeNullsFromUnionMetadataType((MetadataType)metadataType), (Object)metadataType);
    }

    @Test
    public void nullsSimplificationOnUnionTypeOfNullTypesReturnsNullType() {
        UnionTypeBuilder unionTypeBuilder = TypesHelper.getTypeBuilder().unionType();
        unionTypeBuilder.of((TypeBuilder)TypesHelper.getTypeBuilder().nullType());
        unionTypeBuilder.of((TypeBuilder)TypesHelper.getTypeBuilder().nullType());
        Assert.assertThat((Object)TypeUtils.removeNullsFromUnionMetadataType((MetadataType)unionTypeBuilder.build()), (Matcher)IsInstanceOf.instanceOf(NullType.class));
    }

    @Test
    public void nullsSimplificationOnUnionTypeContainingAtMostOneNonNullTypeReturnsThatNonNullType() {
        UnionTypeBuilder unionTypeBuilder = TypesHelper.getTypeBuilder().unionType();
        unionTypeBuilder.of((TypeBuilder)TypesHelper.getTypeBuilder().binaryType());
        unionTypeBuilder.of((TypeBuilder)TypesHelper.getTypeBuilder().nullType());
        unionTypeBuilder.of((TypeBuilder)TypesHelper.getTypeBuilder().nullType());
        Assert.assertThat((Object)TypeUtils.removeNullsFromUnionMetadataType((MetadataType)unionTypeBuilder.build()), (Matcher)IsInstanceOf.instanceOf(BinaryType.class));
    }

    @Test
    public void nullsSimplificationOnUnionTypeContainingMoreThanOneNonNullTypeReturnsUnionOfNonNullTypes() {
        UnionTypeBuilder unionTypeBuilder = TypesHelper.getTypeBuilder().unionType();
        unionTypeBuilder.of((TypeBuilder)TypesHelper.getTypeBuilder().binaryType());
        unionTypeBuilder.of((TypeBuilder)TypesHelper.getTypeBuilder().numberType());
        unionTypeBuilder.of((TypeBuilder)TypesHelper.getTypeBuilder().nullType());
        unionTypeBuilder.of((TypeBuilder)TypesHelper.getTypeBuilder().nullType());
        Assert.assertThat((Object)TypeUtils.removeNullsFromUnionMetadataType((MetadataType)unionTypeBuilder.build()), (Matcher)new MetadataTypeMatcher.IsAs("%type _:Java = Binary | Number"));
    }

    @Test
    public void testOverride() {
        EventType eventType1 = (EventType)Mockito.mock(EventType.class);
        EventType eventType2 = (EventType)Mockito.mock(EventType.class);
        VarDecl varDecl = (VarDecl)Mockito.mock(VarDecl.class);
        List<VarDecl> list = Arrays.asList(varDecl);
        Mockito.when((Object)eventType2.getVarDecls()).thenReturn(list.stream());
        Assert.assertNotNull((Object)TypeUtils.override((EventType)eventType1, (EventType)eventType2));
    }

    @Test
    public void testMinus() {
        EventType eventType1 = (EventType)Mockito.mock(EventType.class);
        EventType eventType2 = (EventType)Mockito.mock(EventType.class);
        VarDecl varDecl = (VarDecl)Mockito.mock(VarDecl.class);
        List<VarDecl> list = Arrays.asList(varDecl);
        Mockito.when((Object)eventType2.getVarDecls()).thenReturn(list.stream());
        Assert.assertNotNull((Object)TypeUtils.minus((EventType)eventType1, (EventType)eventType2));
    }

    @Test
    public void testUnifyTypes() {
        SimpleType type1 = (SimpleType)Mockito.mock(SimpleType.class);
        SimpleType type2 = (SimpleType)Mockito.mock(SimpleType.class);
        Assert.assertNotNull((Object)TypeUtils.unifyTypes((MetadataType)type1, (MetadataType)type2));
    }

    @Test
    public void testSubstitute() {
        DefaultTypeParameterType type1 = (DefaultTypeParameterType)Mockito.mock(DefaultTypeParameterType.class);
        HashMap<String, MetadataType> map = new HashMap<String, MetadataType>();
        map.put("string", (MetadataType)Mockito.mock(MetadataType.class));
        Assert.assertNotNull((Object)TypeUtils.substitute((MetadataType)type1, map));
    }

    @Test
    public void testIsAssignable() {
        Assert.assertFalse((boolean)TypeUtils.isAssignable((MetadataType)((MetadataType)Mockito.mock(MetadataType.class)), (MetadataType)((MetadataType)Mockito.mock(MetadataType.class))));
    }

    @Test
    public void testEnrichWithLocation() throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        VarDecl varDecl = (VarDecl)Mockito.mock(VarDecl.class);
        LocationAnnotation locationAnnotation = (LocationAnnotation)Mockito.mock(LocationAnnotation.class);
        Consumer<LocationAnnotation> consumer = a -> a.getLocation();
        VarDeclMetadata metadata = (VarDeclMetadata)Mockito.mock(VarDeclMetadata.class);
        Mockito.when((Object)varDecl.getMetadata()).thenReturn(Optional.of(metadata));
        Mockito.when((Object)metadata.getComponentLocation()).thenReturn(Optional.of((ComponentLocation)Mockito.mock(ComponentLocation.class)));
        Method method = TypeUtils.class.getDeclaredMethod("enrichWithLocation", VarDecl.class, Consumer.class);
        method.setAccessible(true);
        method.invoke(null, varDecl, consumer);
        Assert.assertNotNull((Object)varDecl);
    }

    @Test
    public void testAnnotate() {
        Assert.assertNotNull((Object)TypeUtils.annotate((EventType)((EventType)Mockito.mock(EventType.class)), (VarDeclMetadata)((VarDeclMetadata)Mockito.mock(VarDeclMetadata.class))));
    }

    @Test
    public void testIntersectionEmptyList() {
        Assert.assertNotNull((Object)TypeUtils.intersection((List)((List)Mockito.mock(List.class)), (ExpressionLanguageMetadataService)((ExpressionLanguageMetadataService)Mockito.mock(ExpressionLanguageMetadataService.class))));
    }

    @Test
    public void testIntersection() {
        EventType eventType = (EventType)Mockito.mock(EventType.class);
        EventType eventType2 = (EventType)Mockito.mock(EventType.class);
        VarDecl varDecl = (VarDecl)Mockito.mock(VarDecl.class);
        VarDecl varDecl2 = (VarDecl)Mockito.mock(VarDecl.class);
        Mockito.when((Object)varDecl.getName()).thenReturn((Object)"test");
        Mockito.when((Object)varDecl2.getName()).thenReturn((Object)"test");
        List<EventType> list = Arrays.asList(eventType, eventType2);
        Mockito.when((Object)eventType.getVarDecls()).thenReturn(Stream.of(varDecl));
        Mockito.when((Object)eventType2.getVarDecls()).thenReturn(Stream.of(varDecl2));
        Mockito.when((Object)varDecl.getType()).thenReturn((Object)((MetadataType)Mockito.mock(SimpleType.class)));
        Mockito.when((Object)varDecl2.getType()).thenReturn((Object)((MetadataType)Mockito.mock(SimpleType.class)));
        ExpressionLanguageMetadataService expressionLanguageMetadataService = (ExpressionLanguageMetadataService)Mockito.mock(ExpressionLanguageMetadataService.class);
        Mockito.when((Object)expressionLanguageMetadataService.intersect((List)ArgumentMatchers.any())).thenReturn((Object)((MetadataType)Mockito.mock(MetadataType.class)));
        Assert.assertNotNull((Object)TypeUtils.intersection(list, (ExpressionLanguageMetadataService)expressionLanguageMetadataService));
    }
}

