/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.datasense.impl.model.operation.OperationCall;
import org.mule.datasense.impl.model.operation.OperationCallBuilder;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.annotators.BaseOperationCallBuilderAnnotator;
import org.mule.datasense.impl.util.extension.DslElementModelVisitor;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;

public abstract class StaticDslBaseAnnotator
extends BaseOperationCallBuilderAnnotator {

    protected static class OperationCallDslElementModelVisitor
    implements DslElementModelVisitor {
        private final OperationCallBuilder operationCallBuilder;
        private boolean hasDynamicType;
        private List<ParameterModel> incompleteForDynamicMetadata;

        public OperationCallDslElementModelVisitor(OperationCallBuilder operationCallBuilder) {
            this.operationCallBuilder = operationCallBuilder;
            this.hasDynamicType = false;
            this.incompleteForDynamicMetadata = new ArrayList<ParameterModel>();
        }

        @Override
        public void visitOperationModel(ComponentAst operationAst) {
            OperationModel model = (OperationModel)operationAst.getModel(OperationModel.class).get();
            this.operationCallBuilder.name(model.getName());
            operationAst.getParameters().stream().forEach(paramAst -> this.onParameter(paramAst.getModel(), (Either<String, Object>)paramAst.getValue()));
            this.operationCallBuilder.errors(model.getErrorModels());
            this.operationCallBuilder.returnType((MetadataType)TypesHelper.getMessageMetadataTypeBuilder().payload(model.getOutput().getType()).attributes(model.getOutputAttributes().getType()).build());
            this.hasDynamicType |= model.getOutput().hasDynamicType() || model.getOutputAttributes().hasDynamicType();
            if (this.hasDynamicType) {
                this.incompleteForDynamicMetadata = OperationCallDslElementModelVisitor.incompleteForDynamicMetadata(this.operationCallBuilder, (ParameterizedModel)model);
            }
        }

        private static List<ParameterModel> incompleteForDynamicMetadata(OperationCallBuilder operationCallBuilder, ParameterizedModel parameterizedModel) {
            ArrayList<ParameterModel> incompleteParameters = new ArrayList<ParameterModel>();
            if (operationCallBuilder != null) {
                OperationCall operationCall = operationCallBuilder.build();
                List allParameterModels = parameterizedModel.getAllParameterModels();
                if (allParameterModels != null) {
                    for (ParameterModel parameterModel : allParameterModels) {
                        MetadataKeyPartModelProperty metadataKeyPartModelProperty = parameterModel.getModelProperty(MetadataKeyPartModelProperty.class).orElse(null);
                        if (!parameterModel.isRequired() || metadataKeyPartModelProperty == null || operationCall.getInputMapping(parameterModel.getName()).isPresent()) continue;
                        incompleteParameters.add(parameterModel);
                    }
                }
            }
            return incompleteParameters;
        }

        private List<ParameterModel> getSourceDeclaredParameterModels(SourceModel sourceModel) {
            if (sourceModel == null) {
                return Collections.emptyList();
            }
            return sourceModel.getParameterGroupModels().stream().flatMap(parameterGroupModel -> parameterGroupModel.getParameterModels().stream()).collect(Collectors.toList());
        }

        @Override
        public void visitSourceModel(ComponentAst sourceAst) {
            SourceModel model = (SourceModel)sourceAst.getModel(SourceModel.class).get();
            this.operationCallBuilder.name(model.getName());
            List<ParameterModel> sourceDeclaredParameterModels = this.getSourceDeclaredParameterModels(model);
            sourceAst.getParameters().stream().filter(componentParameterAst -> sourceDeclaredParameterModels.contains(componentParameterAst.getModel())).forEach(paramAst -> this.onParameter(paramAst.getModel(), (Either<String, Object>)paramAst.getValue()));
            this.operationCallBuilder.errors(model.getErrorModels());
            this.operationCallBuilder.returnType((MetadataType)TypesHelper.getMessageMetadataTypeBuilder().payload(model.getOutput().getType()).attributes(model.getOutputAttributes().getType()).build());
            this.hasDynamicType |= model.getOutput().hasDynamicType() || model.getOutputAttributes().hasDynamicType();
            this.incompleteForDynamicMetadata = OperationCallDslElementModelVisitor.incompleteForDynamicMetadata(this.operationCallBuilder, (ParameterizedModel)model);
        }

        private void addParameter(String name, MetadataType metadataType, Either<String, Object> value) {
            this.operationCallBuilder.input(inputMappingBuilder -> inputMappingBuilder.parameter(inputParameterBuilder -> inputParameterBuilder.name(name).type(metadataType)).argument(inputArgumentBuilder -> {
                value.applyLeft(left -> {
                    inputArgumentBuilder.expression((String)left);
                    inputArgumentBuilder.value((String)left);
                });
                value.applyRight(right -> {
                    if (right instanceof String) {
                        inputArgumentBuilder.value((String)right);
                    }
                });
            }));
        }

        private void onParameter(ParameterModel parameterModel, Either<String, Object> value) {
            this.hasDynamicType |= parameterModel.hasDynamicType();
            value.getValue().ifPresent(v -> this.addParameter(parameterModel.getName(), parameterModel.getType(), value));
        }

        public boolean isHasDynamicType() {
            return this.hasDynamicType;
        }

        public Collection<ParameterModel> isIncompleteForDynamicMetadata() {
            return this.incompleteForDynamicMetadata;
        }
    }
}

