/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.OperationCallAnnotation;
import org.mule.datasense.impl.model.annotations.ThrowsErrorsTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.VoidOperationAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.operation.OperationCall;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.OperationCallTypeResolver;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;

public class OperationCallTypeResolverTest {
    private OperationCallTypeResolver resolver;
    private MessageProcessorNode messageProcessorNode;
    private EventType inputEventType;
    private TypingMuleAstVisitor typingMuleAstVisitor;
    private TypingMuleAstVisitorContext visitorContext;
    private OperationCall operationCall;

    @Before
    public void setUp() {
        this.resolver = new OperationCallTypeResolver();
        this.messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.inputEventType = (EventType)Mockito.mock(EventType.class);
        this.typingMuleAstVisitor = (TypingMuleAstVisitor)Mockito.mock(TypingMuleAstVisitor.class);
        this.visitorContext = (TypingMuleAstVisitorContext)Mockito.mock(TypingMuleAstVisitorContext.class);
        this.operationCall = (OperationCall)Mockito.mock(OperationCall.class);
        OperationCallAnnotation annotation = (OperationCallAnnotation)Mockito.mock(OperationCallAnnotation.class);
        Mockito.when((Object)annotation.getOperationCall()).thenReturn((Object)this.operationCall);
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(OperationCallAnnotation.class)).thenReturn(Optional.of(annotation));
        Mockito.when((Object)this.visitorContext.getAstNotification()).thenReturn((Object)((AstNotification)Mockito.mock(AstNotification.class)));
        Mockito.when((Object)this.messageProcessorNode.getAstNodeLocation()).thenReturn((Object)((AstNodeLocation)Mockito.mock(AstNodeLocation.class)));
    }

    @Test
    public void testResolveWithVoidOperation() {
        Mockito.when((Object)this.messageProcessorNode.isAnnotatedWith(VoidOperationAnnotation.class)).thenReturn((Object)true);
        EventType result = this.resolver.resolve(this.messageProcessorNode, this.inputEventType, this.typingMuleAstVisitor, this.visitorContext);
        Assert.assertEquals((Object)this.inputEventType, (Object)result);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((UsesTypeAnnotation)Mockito.any(UsesTypeAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((ThrowsErrorsTypeAnnotation)Mockito.any(ThrowsErrorsTypeAnnotation.class)));
    }

    @Test
    public void testResolveWithNonVoidOperation() {
        Mockito.when((Object)this.messageProcessorNode.isAnnotatedWith(VoidOperationAnnotation.class)).thenReturn((Object)false);
        MessageMetadataType returnType = (MessageMetadataType)Mockito.mock(MessageMetadataType.class);
        Mockito.when((Object)this.operationCall.getReturnType()).thenReturn((Object)returnType);
        EventType result = this.resolver.resolve(this.messageProcessorNode, this.inputEventType, this.typingMuleAstVisitor, this.visitorContext);
        Assert.assertNotNull((Object)result);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((UsesTypeAnnotation)Mockito.any(UsesTypeAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((ThrowsErrorsTypeAnnotation)Mockito.any(ThrowsErrorsTypeAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((DefinesTypeAnnotation)Mockito.any(DefinesTypeAnnotation.class)));
    }

    @Test
    public void testResolveWithNonMessageReturnType() {
        Mockito.when((Object)this.messageProcessorNode.isAnnotatedWith(VoidOperationAnnotation.class)).thenReturn((Object)false);
        MetadataType returnType = (MetadataType)Mockito.mock(MetadataType.class);
        Mockito.when((Object)this.operationCall.getReturnType()).thenReturn((Object)returnType);
        EventType result = this.resolver.resolve(this.messageProcessorNode, this.inputEventType, this.typingMuleAstVisitor, this.visitorContext);
        Assert.assertEquals((Object)this.inputEventType, (Object)result);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((UsesTypeAnnotation)Mockito.any(UsesTypeAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((ThrowsErrorsTypeAnnotation)Mockito.any(ThrowsErrorsTypeAnnotation.class)));
    }

    @Test
    public void testIsPropagates() {
        Assert.assertTrue((boolean)this.resolver.isPropagates(this.messageProcessorNode));
    }
}

