package org.mule.datasense.impl.phases.builder;

import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.runtime.api.component.ComponentIdentifier;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class MuleApplicationNodeBuilder implements AstNodeBuilder<MuleApplicationNode> {

  private final ComponentIdentifier componentIdentifier;
  private List<MuleFlowNodeBuilder> muleFlowNodeList;
  private String name;

  public MuleApplicationNodeBuilder(ComponentIdentifier componentIdentifier) {
    this.componentIdentifier = componentIdentifier;
    this.muleFlowNodeList = new ArrayList<>();
  }

  public MuleApplicationNodeBuilder name(String name) {
    this.name = name;
    return this;
  }

  public MuleApplicationNodeBuilder muleFlow(ComponentIdentifier componentIdentifier,
                                             Consumer<MuleFlowNodeBuilder> muleFlowNodeBuilderConsumer) {
    MuleFlowNodeBuilder muleFlowNodeBuilder = new MuleFlowNodeBuilder(componentIdentifier);
    if (muleFlowNodeBuilderConsumer != null) {
      muleFlowNodeBuilderConsumer.accept(muleFlowNodeBuilder);
    }
    return muleFlow(muleFlowNodeBuilder);
  }

  public MuleApplicationNodeBuilder muleFlow(MuleFlowNodeBuilder muleFlowNodeBuilder) {
    muleFlowNodeList.add(muleFlowNodeBuilder);
    return this;
  }

  public MuleApplicationNode build() {
    List<MuleFlowNode> muleFlowNodes = muleFlowNodeList.stream().map(MuleFlowNodeBuilder::build).collect(Collectors.toList());
    MuleApplicationNode muleApplicationNode =
        new MuleApplicationNode(componentIdentifier, muleFlowNodes.stream());
    muleApplicationNode.setName(name);
    muleFlowNodes.forEach(muleFlowNode -> muleFlowNode.setParentAstNode(muleApplicationNode));
    return muleApplicationNode;
  }
}
