package org.mule.datasense.impl.model.event;

import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;

public class ValueExpr implements DefElemValueExpr {

  private final Expr value;

  public ValueExpr(Expr value) {
    this.value = value;
  }

  @Override
  public MetadataType resolveType(MuleEventMetadataType muleEventMetadataType,
                                  ResolveTypeContext resolveTypeContext) {
    return value.resolveType(muleEventMetadataType, resolveTypeContext);
  }

  @Override
  public void resolveInputType(MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder, MetadataType metadataType,
                               ResolveTypeContext resolveTypeContext) {
    value.resolveInputType(metadataType, muleEventMetadataTypeBuilder, resolveTypeContext);
  }
}
