/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.CompositeErrorMatcher;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorHandlingUtils;
import org.mule.datasense.impl.phases.typing.resolver.errorhandling.ErrorMatcher;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;

public class ErrorHandlingUtilsTest {
    @Test
    public void testCreateErrorModel() {
        Optional result = ErrorHandlingUtils.createErrorModel((String)"NAMESPACE:ERROR");
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"ERROR", (Object)((ErrorModel)result.get()).getType());
        Assert.assertEquals((Object)"NAMESPACE", (Object)((ErrorModel)result.get()).getNamespace());
        result = ErrorHandlingUtils.createErrorModel((String)"ERROR");
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"ERROR", (Object)((ErrorModel)result.get()).getType());
        Assert.assertEquals((Object)"", (Object)((ErrorModel)result.get()).getNamespace());
        result = ErrorHandlingUtils.createErrorModel((String)"");
        Assert.assertFalse((boolean)result.isPresent());
        result = ErrorHandlingUtils.createErrorModel(null);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testCreateErrorCode() {
        Optional result = ErrorHandlingUtils.createErrorCode((String)"NAMESPACE:ERROR");
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"ERROR", (Object)((QName)result.get()).getLocalPart());
        Assert.assertEquals((Object)"NAMESPACE", (Object)((QName)result.get()).getNamespaceURI());
        result = ErrorHandlingUtils.createErrorCode((String)"ERROR");
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)"ERROR", (Object)((QName)result.get()).getLocalPart());
        Assert.assertEquals((Object)"", (Object)((QName)result.get()).getNamespaceURI());
        result = ErrorHandlingUtils.createErrorCode((String)"");
        Assert.assertFalse((boolean)result.isPresent());
        result = ErrorHandlingUtils.createErrorCode(null);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testGetErrorCodes() {
        ErrorModel parentError = ErrorModelBuilder.newError((String)"PARENT", (String)"PARENT_NS").build();
        ErrorModel childError = ErrorModelBuilder.newError((String)"CHILD", (String)"CHILD_NS").withParent(parentError).build();
        List result = ErrorHandlingUtils.getErrorCodes((ErrorModel)childError);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)new QName("CHILD_NS", "CHILD"), result.get(0));
        Assert.assertEquals((Object)new QName("PARENT_NS", "PARENT"), result.get(1));
    }

    @Test
    public void testCreateErrorMatcher() {
        ErrorMatcher matcher = ErrorHandlingUtils.createErrorMatcher((String)"ERROR1, ERROR2, ERROR3");
        Assert.assertTrue((boolean)(matcher instanceof CompositeErrorMatcher));
        CompositeErrorMatcher compositeMatcher = (CompositeErrorMatcher)matcher;
        Assert.assertNotEquals((Object)compositeMatcher, null);
    }

    @Test
    public void testErrorType() {
        HashSet<ErrorModel> errors = new HashSet<ErrorModel>();
        errors.add(ErrorModelBuilder.newError((String)"ERROR1", (String)"NS1").build());
        errors.add(ErrorModelBuilder.newError((String)"ERROR2", (String)"NS2").build());
        MetadataType result = ErrorHandlingUtils.errorType(errors);
        Assert.assertTrue((boolean)(result instanceof ObjectType));
        ObjectType objectType = (ObjectType)result;
        Assert.assertTrue((boolean)objectType.getFields().stream().anyMatch(f -> f.getKey().getName().getLocalPart().equals("description")));
        Assert.assertTrue((boolean)objectType.getFields().stream().anyMatch(f -> f.getKey().getName().getLocalPart().equals("detailedDescription")));
        Assert.assertTrue((boolean)objectType.getFields().stream().anyMatch(f -> f.getKey().getName().getLocalPart().equals("errorType")));
        Optional<ObjectType> errorTypeField = objectType.getFields().stream().filter(f -> f.getKey().getName().getLocalPart().equals("errorType")).map(f -> (ObjectType)f.getValue()).findFirst();
        Assert.assertTrue((boolean)errorTypeField.isPresent());
        ObjectType errorType = errorTypeField.get();
        Assert.assertTrue((boolean)errorType.getFields().stream().anyMatch(f -> f.getKey().getName().getLocalPart().equals("namespace")));
        Assert.assertTrue((boolean)errorType.getFields().stream().anyMatch(f -> f.getKey().getName().getLocalPart().equals("identifier")));
    }
}

