/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.event;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.datasense.impl.model.event.SimpleExpr;
import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

public class SimpleExprTest {
    @Mock
    private ResolveTypeContext mockResolveTypeContext;
    @Mock
    private MuleEventMetadataType mockMuleEventMetadataType;
    @Mock
    private ExpressionLanguageMetadataService mockExpressionLanguageMetadataService;
    @Mock
    private ExpressionLanguageMetadataService.MessageCallback mockMessageCallback;
    @Mock
    private MetadataType mockMetadataType;
    @Mock
    private MuleEventMetadataTypeBuilder mockMuleEventMetadataTypeBuilder;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockResolveTypeContext.getExpressionLanguageMetadataService()).thenReturn((Object)this.mockExpressionLanguageMetadataService);
        Mockito.when((Object)this.mockResolveTypeContext.getMessageCallbackFactory()).thenReturn(expression -> this.mockMessageCallback);
    }

    @Test
    public void testConstructorWithValidExpression() {
        SimpleExpr simpleExpr = new SimpleExpr("validExpression", null);
        Assert.assertNotNull((Object)simpleExpr);
    }

    @Test(expected=NullPointerException.class)
    public void testConstructorWithNullExpression() {
        new SimpleExpr(null, null);
    }

    @Test
    public void testResolveTypeWithMimeType() {
        SimpleExpr simpleExpr = new SimpleExpr("testExpression", "application/json");
        TypeBindings mockTypeBindings = TypeBindings.builder().build();
        Mockito.when((Object)this.mockResolveTypeContext.getTypeBindings()).thenReturn((Object)mockTypeBindings);
        MetadataType expectedMetadataType = (MetadataType)Mockito.mock(MetadataType.class);
        Mockito.when((Object)this.mockExpressionLanguageMetadataService.getOutputType((TypeBindings)Mockito.any(TypeBindings.class), (String)Mockito.eq((Object)"testExpression"), (String)Mockito.eq((Object)"application/json"), (ExpressionLanguageMetadataService.MessageCallback)Mockito.eq((Object)this.mockMessageCallback))).thenReturn((Object)expectedMetadataType);
        Mockito.when((Object)this.mockMuleEventMetadataType.getMessageType()).thenReturn((Object)((MessageMetadataType)Mockito.mock(MessageMetadataType.class)));
        MetadataType result = simpleExpr.resolveType(this.mockMuleEventMetadataType, this.mockResolveTypeContext);
        Assert.assertEquals((Object)expectedMetadataType, (Object)result);
        ((ExpressionLanguageMetadataService)Mockito.verify((Object)this.mockExpressionLanguageMetadataService)).getOutputType((TypeBindings)Mockito.any(TypeBindings.class), (String)Mockito.eq((Object)"testExpression"), (String)Mockito.eq((Object)"application/json"), (ExpressionLanguageMetadataService.MessageCallback)Mockito.eq((Object)this.mockMessageCallback));
    }

    @Test
    public void testResolveInputType() {
        SimpleExpr simpleExpr = new SimpleExpr("testExpression", null);
        simpleExpr.resolveInputType(this.mockMetadataType, this.mockMuleEventMetadataTypeBuilder, this.mockResolveTypeContext);
        ((ExpressionLanguageMetadataService)Mockito.verify((Object)this.mockExpressionLanguageMetadataService)).getInputType((String)Mockito.eq((Object)"testExpression"), (MetadataType)Mockito.eq((Object)this.mockMetadataType), (MuleEventMetadataTypeBuilder)Mockito.eq((Object)this.mockMuleEventMetadataTypeBuilder), (ExpressionLanguageMetadataService.MessageCallback)Mockito.eq((Object)this.mockMessageCallback));
    }
}

