/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl;

import java.net.URI;
import java.util.Arrays;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.datasense.impl.ApplicationModelResolver;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.apikit.metadata.api.Metadata;
import org.mule.runtime.apikit.metadata.api.MetadataBuilder;
import org.mule.runtime.apikit.metadata.api.Notifier;
import org.mule.runtime.apikit.metadata.api.ResourceLoader;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class DataSenseProviderResolverTest {
    @Mock
    private DataSenseProvider dataSenseProvider;
    @Mock
    private ApplicationModelResolver applicationModelResolver;
    @Mock
    private AstNotification astNotification;
    @Mock
    private ApplicationModel applicationModel;
    @Mock
    private MetadataBuilder apiKitMetadataBuilder;
    @Mock
    private Metadata apiKitMetadata;
    @Mock
    private ExpressionLanguageMetadataService expressionLanguageMetadataService;
    @Mock
    private TypeLoader typeLoader;
    @Mock
    private MetadataType mockMetadataType;
    @Mock
    private ComponentAst componentAst;
    @Mock
    private MessageProcessorNode messageProcessorNode;
    private DataSenseProviderResolver resolver;
    private static final String SAMPLE_TYPES_DATA = "<types xmlns=\"http://www.mulesoft.org/schema/mule/metadata\">\n  <catalog>\n    <type name=\"test:SimpleType\">\n      <java-type class=\"java.lang.String\" />\n    </type>\n  </catalog>\n</types>";
    private static final String SAMPLE_ENRICHMENT_DATA = "<enrichments xmlns=\"http://www.mulesoft.org/schema/mule/metadata\">\n  <component-enrichment>\n    <target-component>\n      <name>testComponent</name>\n    </target-component>\n  </component-enrichment>\n</enrichments>";

    @Before
    public void setUp() throws Exception {
        Mockito.lenient().when((Object)this.applicationModelResolver.getApplicationModel()).thenReturn((Object)this.applicationModel);
        Mockito.lenient().when((Object)this.applicationModel.findTypesDataList()).thenReturn(Arrays.asList(SAMPLE_TYPES_DATA, SAMPLE_ENRICHMENT_DATA));
        URI testResourceUri = new URI("test://resource");
        Mockito.lenient().when((Object)this.applicationModel.findResource(ArgumentMatchers.anyString())).thenReturn(Optional.of(testResourceUri));
        Mockito.lenient().when((Object)this.dataSenseProvider.getApikitMetadataBuilder()).thenReturn((Object)this.apiKitMetadataBuilder);
        Mockito.lenient().when((Object)this.apiKitMetadataBuilder.withApplicationModel((ArtifactAst)ArgumentMatchers.any())).thenReturn((Object)this.apiKitMetadataBuilder);
        Mockito.lenient().when((Object)this.apiKitMetadataBuilder.withResourceLoader((ResourceLoader)ArgumentMatchers.any(ResourceLoader.class))).thenReturn((Object)this.apiKitMetadataBuilder);
        Mockito.lenient().when((Object)this.apiKitMetadataBuilder.withNotifier((Notifier)ArgumentMatchers.any())).thenReturn((Object)this.apiKitMetadataBuilder);
        Mockito.lenient().when((Object)this.apiKitMetadataBuilder.build()).thenReturn((Object)this.apiKitMetadata);
        Mockito.lenient().when((Object)this.expressionLanguageMetadataService.createTypeLoader(ArgumentMatchers.anyString(), (MetadataFormat)ArgumentMatchers.any(MetadataFormat.class))).thenReturn((Object)this.typeLoader);
        Mockito.lenient().when((Object)this.typeLoader.load(ArgumentMatchers.anyString())).thenReturn(Optional.of(this.mockMetadataType));
        Mockito.lenient().when((Object)this.dataSenseProvider.getExpressionLanguageMetadataService()).thenReturn((Object)this.expressionLanguageMetadataService);
        Mockito.lenient().when((Object)this.componentAst.getLocation()).thenReturn((Object)((ComponentLocation)Mockito.mock(ComponentLocation.class)));
        Mockito.lenient().when((Object)this.componentAst.getIdentifier()).thenReturn((Object)((ComponentIdentifier)Mockito.mock(ComponentIdentifier.class)));
    }

    @Test
    public void testIsDynamicDataSenseSupportedFor() {
        ComponentIdentifier identifier = (ComponentIdentifier)Mockito.mock(ComponentIdentifier.class);
        Mockito.when((Object)this.messageProcessorNode.getComponentIdentifier()).thenReturn((Object)identifier);
        Assert.assertTrue((boolean)DataSenseProviderResolver.isDynamicDataSenseSupportedFor((MessageProcessorNode)this.messageProcessorNode));
    }

    @Test
    public void testConstructorInitializesSuccessfully() {
        this.resolver = (DataSenseProviderResolver)Mockito.spy((Object)((Object)new TestDataSenseProviderResolver(this.dataSenseProvider, this.applicationModelResolver, this.astNotification)));
        Assert.assertNotNull((Object)this.resolver);
        Assert.assertEquals((Object)this.dataSenseProvider, (Object)this.resolver.getDataSenseProvider());
        Assert.assertEquals((Object)this.applicationModelResolver, (Object)this.resolver.getApplicationModelResolver());
        Assert.assertEquals((Object)this.astNotification, (Object)this.resolver.getAstNotification());
    }

    @Test
    public void testResolveSourceModel() {
        this.resolver = (DataSenseProviderResolver)Mockito.spy((Object)((Object)new TestDataSenseProviderResolver(this.dataSenseProvider, this.applicationModelResolver, this.astNotification)));
        Optional result = this.resolver.resolveSourceModel(this.componentAst);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(Optional.empty(), (Object)result);
    }

    @Test
    public void testResolveOperationModel() {
        this.resolver = (DataSenseProviderResolver)Mockito.spy((Object)((Object)new TestDataSenseProviderResolver(this.dataSenseProvider, this.applicationModelResolver, this.astNotification)));
        Optional result = this.resolver.resolveOperationModel(this.componentAst);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(Optional.empty(), (Object)result);
    }

    @Test
    public void testFindMessageProcessorTypeDeclaration() {
        this.resolver = (DataSenseProviderResolver)Mockito.spy((Object)((Object)new TestDataSenseProviderResolver(this.dataSenseProvider, this.applicationModelResolver, this.astNotification)));
        Optional result = this.resolver.findMessageProcessorTypeDeclaration(this.componentAst);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testFindExtensionOperationTypeDeclaration() {
        this.resolver = (DataSenseProviderResolver)Mockito.spy((Object)((Object)new TestDataSenseProviderResolver(this.dataSenseProvider, this.applicationModelResolver, this.astNotification)));
        Optional result = this.resolver.findExtensionOperationTypeDeclaration(this.componentAst);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetApiKitMetadata() {
        this.resolver = (DataSenseProviderResolver)Mockito.spy((Object)((Object)new TestDataSenseProviderResolver(this.dataSenseProvider, this.applicationModelResolver, this.astNotification)));
        Optional result = this.resolver.getApiKitMetadata();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(Optional.empty(), (Object)result);
    }

    @Test
    public void testGetSoapKitMetadata() {
        this.resolver = (DataSenseProviderResolver)Mockito.spy((Object)((Object)new TestDataSenseProviderResolver(this.dataSenseProvider, this.applicationModelResolver, this.astNotification)));
        Optional result = this.resolver.getSoapKitMetadata();
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testGettersAfterInitialization() {
        this.resolver = (DataSenseProviderResolver)Mockito.spy((Object)((Object)new TestDataSenseProviderResolver(this.dataSenseProvider, this.applicationModelResolver, this.astNotification)));
        Assert.assertNotNull((Object)this.resolver.getTypesCatalog());
        Assert.assertNotNull((Object)this.resolver.getComponentModelEnrichments());
        Assert.assertNotNull((Object)this.resolver.getExpressionLanguageMetadataService());
    }

    private static class TestDataSenseProviderResolver
    extends DataSenseProviderResolver {
        public TestDataSenseProviderResolver(DataSenseProvider dataSenseProvider, ApplicationModelResolver applicationModelResolver, AstNotification astNotification) {
            super(dataSenseProvider, applicationModelResolver, astNotification);
        }

        public Optional<SourceModel> resolveSourceModel(ComponentAst componentAst) {
            return Optional.empty();
        }

        public Optional<OperationModel> resolveOperationModel(ComponentAst componentAst) {
            return Optional.empty();
        }

        public Optional<Metadata> getApiKitMetadata() {
            return Optional.empty();
        }
    }
}

