/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util.metadatatype;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.types.MetadataTypeTransform;
import org.mule.datasense.impl.util.matchers.MetadataTypeMatcher;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.FunctionTypeBuilder;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.impl.DefaultAnyType;
import org.mule.metadata.api.model.impl.DefaultArrayType;
import org.mule.metadata.api.model.impl.DefaultAttributeFieldType;
import org.mule.metadata.api.model.impl.DefaultAttributeKeyType;
import org.mule.metadata.api.model.impl.DefaultBinaryType;
import org.mule.metadata.api.model.impl.DefaultBooleanType;
import org.mule.metadata.api.model.impl.DefaultDateTimeType;
import org.mule.metadata.api.model.impl.DefaultDateType;
import org.mule.metadata.api.model.impl.DefaultFunctionType;
import org.mule.metadata.api.model.impl.DefaultIntersectionType;
import org.mule.metadata.api.model.impl.DefaultLocalDateTimeType;
import org.mule.metadata.api.model.impl.DefaultLocalTimeType;
import org.mule.metadata.api.model.impl.DefaultNothingType;
import org.mule.metadata.api.model.impl.DefaultNullType;
import org.mule.metadata.api.model.impl.DefaultNumberType;
import org.mule.metadata.api.model.impl.DefaultObjectFieldType;
import org.mule.metadata.api.model.impl.DefaultObjectKeyType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.metadata.api.model.impl.DefaultPeriodType;
import org.mule.metadata.api.model.impl.DefaultRegexType;
import org.mule.metadata.api.model.impl.DefaultStringType;
import org.mule.metadata.api.model.impl.DefaultTimeType;
import org.mule.metadata.api.model.impl.DefaultTimeZoneType;
import org.mule.metadata.api.model.impl.DefaultTupleType;
import org.mule.metadata.api.model.impl.DefaultTypeParameterType;
import org.mule.metadata.api.model.impl.DefaultUnionType;
import org.mule.metadata.api.model.impl.DefaultVoidType;

public class MetadataTypeTransformTest {
    private BaseTypeBuilder getTypeBuilder() {
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
    }

    @Test
    public void test() {
        BaseTypeBuilder typeBuilder = this.getTypeBuilder();
        final HashMap<String, NumberType> substitutions = new HashMap<String, NumberType>();
        substitutions.put("T", typeBuilder.numberType().build());
        FunctionTypeBuilder functionBuild = typeBuilder.functionType();
        BaseTypeBuilder parameterTypeBuilder = this.getTypeBuilder();
        parameterTypeBuilder.arrayType().of().typeParameter("T");
        functionBuild.addParameterOf("value", parameterTypeBuilder.build());
        BaseTypeBuilder returnTypeBuilder = this.getTypeBuilder();
        returnTypeBuilder.typeParameter("T");
        functionBuild.returnType(returnTypeBuilder.build());
        FunctionType functionType = functionBuild.build();
        MetadataTypeTransform substitutionTransform = new MetadataTypeTransform(){

            protected MetadataType transformDefaultTypeParameterType(String name, MetadataFormat metadataFormat, Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
                return (MetadataType)substitutions.get(name);
            }
        };
        MetadataType transformedFunctionType = substitutionTransform.transform((MetadataType)functionType);
        Assert.assertThat((Object)transformedFunctionType, (Matcher)new MetadataTypeMatcher.IsAs("%type _:Java = (value:[Number]) -> Number"));
    }

    @Test
    public void testTransform() {
        MetadataTypeTransform metadataTypeTransform = new MetadataTypeTransform();
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultTypeParameterType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultAnyType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultArrayType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultBinaryType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultBooleanType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultDateTimeType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultDateType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultNullType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultVoidType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultNumberType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultObjectType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultStringType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultTimeType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultTupleType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultUnionType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultIntersectionType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultObjectKeyType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultAttributeKeyType.class)));
        try {
            Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultAttributeFieldType.class)));
        }
        catch (Exception e) {
            Assert.assertNotNull((Object)e);
        }
        try {
            Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultObjectFieldType.class)));
        }
        catch (Exception e) {
            Assert.assertNotNull((Object)e);
        }
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultNothingType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultFunctionType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultLocalDateTimeType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultLocalTimeType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultPeriodType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultRegexType.class)));
        Assert.assertNotNull((Object)metadataTypeTransform.transform((MetadataType)Mockito.mock(DefaultTimeZoneType.class)));
    }

    @Test
    public void testVisitAttributeKey() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        MetadataTypeTransform metadataTypeTransform = new MetadataTypeTransform();
        Method method = MetadataTypeTransform.class.getDeclaredMethod("visitAttributeKey", DefaultAttributeKeyType.class);
        method.setAccessible(true);
        Assert.assertNotNull((Object)method.invoke((Object)metadataTypeTransform, Mockito.mock(DefaultAttributeKeyType.class)));
    }
}

