/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.util.LocationUtils;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.component.location.LocationPart;

@RunWith(value=MockitoJUnitRunner.class)
public class LocationUtilsTest {
    @Mock
    private Location mockLocation;

    @Test
    public void testIsFlowReturnsTrueForEmptyLocation() {
        Location location = Location.builder().globalName("myFlow").build();
        Assert.assertTrue((boolean)LocationUtils.isFlow((Location)location));
    }

    @Test
    public void testIsFlowReturnsFalseForNonEmptyLocation() {
        Location location = Location.builder().globalName("myFlow").addProcessorsPart().addIndexPart(0).build();
        Assert.assertFalse((boolean)LocationUtils.isFlow((Location)location));
    }

    @Test
    public void testValueOfCreatesLocationFromString() {
        String locationString = "myFlow/processors/0";
        Location location = LocationUtils.valueOf((String)locationString);
        Assert.assertNotNull((Object)location);
        Assert.assertEquals((Object)"myFlow", (Object)location.getGlobalName());
        List parts = location.getParts();
        Assert.assertEquals((long)2L, (long)parts.size());
        Assert.assertEquals((Object)"processors", parts.get(0));
        Assert.assertEquals((Object)"0", parts.get(1));
    }

    @Test
    public void testAsComponentLocationCreatesComponentLocation() {
        Location location = Location.builder().globalName("myFlow").addProcessorsPart().addIndexPart(0).build();
        ComponentLocation componentLocation = LocationUtils.asComponentLocation((String)"testComponent", (Location)location);
        Assert.assertNotNull((Object)componentLocation);
        List parts = componentLocation.getParts().stream().map(part -> part.getPartPath()).collect(Collectors.toList());
        Assert.assertEquals((long)3L, (long)parts.size());
        Assert.assertEquals((Object)"myFlow", parts.get(0));
        Assert.assertEquals((Object)"processors", parts.get(1));
        Assert.assertEquals((Object)"0", parts.get(2));
    }

    @Test
    public void testAsComponentLocation_WithNameAndLocation() {
        String name = "testName";
        Mockito.when((Object)this.mockLocation.getGlobalName()).thenReturn((Object)"globalName");
        Mockito.when((Object)this.mockLocation.getParts()).thenReturn(Arrays.asList("part1", "part2"));
        ComponentLocation result = LocationUtils.asComponentLocation((String)name, (Location)this.mockLocation);
        Assert.assertNotNull((Object)result);
        List parts = result.getParts();
        Assert.assertEquals((long)3L, (long)parts.size());
        Assert.assertEquals((Object)"globalName", (Object)((LocationPart)parts.get(0)).getPartPath());
        Assert.assertEquals((Object)"part1", (Object)((LocationPart)parts.get(1)).getPartPath());
        Assert.assertEquals((Object)"part2", (Object)((LocationPart)parts.get(2)).getPartPath());
    }

    @Test
    public void testAsComponentLocation_WithNullName() {
        Mockito.when((Object)this.mockLocation.getGlobalName()).thenReturn((Object)"globalName");
        Mockito.when((Object)this.mockLocation.getParts()).thenReturn(Arrays.asList("part1", "part2"));
        ComponentLocation result = LocationUtils.asComponentLocation(null, (Location)this.mockLocation);
        Assert.assertNotNull((Object)result);
    }
}

