/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.VarDecl;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.PipedChainTypeResolver;
import org.mule.metadata.api.model.MetadataType;

public class PipedChainTypeResolverTest {
    private PipedChainTypeResolver resolver;
    @Mock
    private MessageProcessorNode messageProcessorNode;
    @Mock
    private TypingMuleAstVisitor typingMuleAstVisitor;
    @Mock
    private TypingMuleAstVisitorContext typingMuleAstVisitorContext;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.resolver = new PipedChainTypeResolver(){};
    }

    @Test
    public void testResolveWithEmptyChain() {
        EventType inputEventType = new EventType(Arrays.asList((VarDecl)Mockito.mock(VarDecl.class)).stream());
        Mockito.when((Object)this.messageProcessorNode.getMessageProcessorNodes()).thenReturn(Stream.empty());
        EventType result = this.resolver.resolve(this.messageProcessorNode, inputEventType, this.typingMuleAstVisitor, this.typingMuleAstVisitorContext);
        Assert.assertEquals((Object)inputEventType, (Object)result);
    }

    @Test
    public void testResolveWithSingleProcessor() {
        EventType inputEventType = new EventType(Collections.singletonList(new VarDecl("input", (MetadataType)Mockito.mock(MetadataType.class))).stream());
        EventType outputEventType = new EventType(Collections.singletonList(new VarDecl("output", (MetadataType)Mockito.mock(MetadataType.class))).stream());
        MessageProcessorNode childNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Mockito.when((Object)this.messageProcessorNode.getMessageProcessorNodes()).thenReturn(Stream.of(childNode));
        Mockito.when((Object)this.typingMuleAstVisitor.resolveType((AstNode)childNode, inputEventType, this.typingMuleAstVisitorContext)).thenReturn((Object)outputEventType);
        EventType result = this.resolver.resolve(this.messageProcessorNode, inputEventType, this.typingMuleAstVisitor, this.typingMuleAstVisitorContext);
        Assert.assertEquals((Object)outputEventType, (Object)result);
    }

    @Test
    public void testResolveWithMultipleProcessors() {
        EventType inputEventType = new EventType(Collections.singletonList(new VarDecl("input", (MetadataType)Mockito.mock(MetadataType.class))).stream());
        EventType intermediateEventType = new EventType(Collections.singletonList(new VarDecl("intermediate", (MetadataType)Mockito.mock(MetadataType.class))).stream());
        EventType outputEventType = new EventType(Collections.singletonList(new VarDecl("output", (MetadataType)Mockito.mock(MetadataType.class))).stream());
        MessageProcessorNode childNode1 = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        MessageProcessorNode childNode2 = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        Mockito.when((Object)this.messageProcessorNode.getMessageProcessorNodes()).thenReturn(Stream.of(childNode1, childNode2));
        Mockito.when((Object)this.typingMuleAstVisitor.resolveType((AstNode)childNode1, inputEventType, this.typingMuleAstVisitorContext)).thenReturn((Object)intermediateEventType);
        Mockito.when((Object)this.typingMuleAstVisitor.resolveType((AstNode)childNode2, intermediateEventType, this.typingMuleAstVisitorContext)).thenReturn((Object)outputEventType);
        EventType result = this.resolver.resolve(this.messageProcessorNode, inputEventType, this.typingMuleAstVisitor, this.typingMuleAstVisitorContext);
        Assert.assertEquals((Object)outputEventType, (Object)result);
    }

    @Test
    public void testIsPropagates() {
        Assert.assertTrue((boolean)this.resolver.isPropagates(this.messageProcessorNode));
    }
}

