/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.ast;

import java.util.Optional;
import java.util.OptionalInt;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.runtime.api.component.location.ComponentLocation;

@RunWith(value=MockitoJUnitRunner.class)
public class AstNodeLocationTest {
    @Mock
    private ComponentLocation mockComponentLocation;
    private AstNodeLocation astNodeLocation;

    @Before
    public void setUp() {
        this.astNodeLocation = new AstNodeLocation(this.mockComponentLocation);
    }

    @Test
    public void testConstructorWithValidComponentLocation() {
        Assert.assertNotNull((Object)this.astNodeLocation);
        Assert.assertEquals((Object)this.mockComponentLocation, (Object)this.astNodeLocation.getComponentLocation());
    }

    @Test(expected=NullPointerException.class)
    public void testConstructorWithNullComponentLocation() {
        new AstNodeLocation(null);
    }

    @Test
    public void testEquals() {
        AstNodeLocation sameLocation = new AstNodeLocation(this.mockComponentLocation);
        AstNodeLocation differentLocation = new AstNodeLocation((ComponentLocation)Mockito.mock(ComponentLocation.class));
        Assert.assertTrue((boolean)this.astNodeLocation.equals((Object)this.astNodeLocation));
        Assert.assertTrue((boolean)this.astNodeLocation.equals((Object)sameLocation));
        Assert.assertFalse((boolean)this.astNodeLocation.equals((Object)differentLocation));
        Assert.assertFalse((boolean)this.astNodeLocation.equals(null));
        Assert.assertFalse((boolean)this.astNodeLocation.equals(new Object()));
    }

    @Test
    public void testHashCode() {
        Assert.assertNotEquals((long)-1L, (long)this.astNodeLocation.hashCode());
    }

    @Test
    public void testToString() {
        Mockito.when((Object)this.mockComponentLocation.getFileName()).thenReturn(Optional.of("test.xml"));
        Mockito.when((Object)this.mockComponentLocation.getLine()).thenReturn((Object)OptionalInt.of(1));
        Mockito.when((Object)this.mockComponentLocation.getLocation()).thenReturn((Object)"flow/processors/0");
        String expected = "[test.xml:10]:flow/processors/0";
        Assert.assertNotEquals((Object)expected, (Object)this.astNodeLocation.toString());
    }

    @Test
    public void testToStringWithUnknownFileName() {
        Mockito.when((Object)this.mockComponentLocation.getFileName()).thenReturn(Optional.empty());
        Mockito.when((Object)this.mockComponentLocation.getLine()).thenReturn((Object)OptionalInt.of(1));
        Mockito.when((Object)this.mockComponentLocation.getLocation()).thenReturn((Object)"flow/processors/0");
        String expected = "[unknown:10]:flow/processors/0";
        Assert.assertNotEquals((Object)expected, (Object)this.astNodeLocation.toString());
    }

    @Test
    public void testToStringWithUnknownLine() {
        Mockito.when((Object)this.mockComponentLocation.getFileName()).thenReturn(Optional.of("test.xml"));
        Mockito.when((Object)this.mockComponentLocation.getLine()).thenReturn((Object)OptionalInt.empty());
        Mockito.when((Object)this.mockComponentLocation.getLocation()).thenReturn((Object)"flow/processors/0");
        String expected = "[test.xml:-1]:flow/processors/0";
        Assert.assertEquals((Object)expected, (Object)this.astNodeLocation.toString());
    }
}

