/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.api.metadataprovider;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.datasense.api.metadataprovider.DefaultApplicationModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;

public class DefaultApplicationModelTest {
    @Mock
    private ArtifactAst mockArtifactAst;
    @Mock
    private ComponentAst mockComponentAst;
    @Mock
    private Function<String, Optional<URI>> mockResourceResolver;
    private DefaultApplicationModel applicationModel;

    @Before
    public void setUp() {
        MockitoAnnotations.openMocks((Object)this);
    }

    @Test
    public void testConstructorWithNameAndArtifactAst() {
        this.applicationModel = new DefaultApplicationModel("TestApp", this.mockArtifactAst);
        Assert.assertEquals((Object)"TestApp", (Object)this.applicationModel.getName());
        Assert.assertSame((Object)this.mockArtifactAst, (Object)this.applicationModel.getMuleApplicationModel());
        Assert.assertEquals((long)1L, (long)this.applicationModel.findTypesDataList().size());
        Assert.assertFalse((boolean)this.applicationModel.getResourceResolver().isPresent());
    }

    @Test
    public void testConstructorWithNameArtifactAstAndTypesData() {
        this.applicationModel = new DefaultApplicationModel("TestApp", this.mockArtifactAst, "TypesData");
        Assert.assertEquals((Object)"TestApp", (Object)this.applicationModel.getName());
        Assert.assertSame((Object)this.mockArtifactAst, (Object)this.applicationModel.getMuleApplicationModel());
        Assert.assertEquals(Collections.singletonList("TypesData"), (Object)this.applicationModel.findTypesDataList());
        Assert.assertFalse((boolean)this.applicationModel.getResourceResolver().isPresent());
    }

    @Test
    public void testConstructorWithAllParameters() {
        List<String> typesDataList = Arrays.asList("Type1", "Type2");
        this.applicationModel = new DefaultApplicationModel("TestApp", this.mockArtifactAst, typesDataList, this.mockResourceResolver);
        Assert.assertEquals((Object)"TestApp", (Object)this.applicationModel.getName());
        Assert.assertSame((Object)this.mockArtifactAst, (Object)this.applicationModel.getMuleApplicationModel());
        Assert.assertEquals(typesDataList, (Object)this.applicationModel.findTypesDataList());
        Assert.assertTrue((boolean)this.applicationModel.getResourceResolver().isPresent());
    }

    @Test
    public void testFindNamedComponentWhenExists() {
        Mockito.when((Object)this.mockArtifactAst.topLevelComponentsStream()).thenReturn(Stream.of(this.mockComponentAst));
        Mockito.when((Object)this.mockComponentAst.getComponentId()).thenReturn(Optional.of("testComponent"));
        this.applicationModel = new DefaultApplicationModel("TestApp", this.mockArtifactAst);
        Optional result = this.applicationModel.findNamedComponent("testComponent");
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertSame((Object)this.mockComponentAst, result.get());
    }

    @Test
    public void testFindNamedComponentWhenNotExists() {
        Mockito.when((Object)this.mockArtifactAst.topLevelComponentsStream()).thenReturn(Stream.empty());
        this.applicationModel = new DefaultApplicationModel("TestApp", this.mockArtifactAst);
        Optional result = this.applicationModel.findNamedComponent("nonExistentComponent");
        Assert.assertFalse((boolean)result.isPresent());
    }

    public void testFindResourceWhenResolverPresent() {
        String resourceName = "resource1.xml";
        URI mockUri = URI.create("file:///test/" + resourceName);
        Mockito.when(this.mockResourceResolver.apply(resourceName)).thenReturn(Optional.of(mockUri));
        this.applicationModel = new DefaultApplicationModel("TestApp", this.mockArtifactAst, Collections.emptyList(), this.mockResourceResolver);
        Optional result = this.applicationModel.findResource(resourceName);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)mockUri, result.get());
    }

    @Test
    public void testFindResourceWhenResolverNotPresent() {
        this.applicationModel = new DefaultApplicationModel("TestApp", this.mockArtifactAst);
        Optional result = this.applicationModel.findResource("resource.xml");
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testFindResourceWhenResolverReturnsEmpty() {
        Mockito.when(this.mockResourceResolver.apply(Mockito.anyString())).thenReturn(Optional.empty());
        this.applicationModel = new DefaultApplicationModel("TestApp", this.mockArtifactAst, Collections.emptyList(), this.mockResourceResolver);
        Optional result = this.applicationModel.findResource("nonExistentResource.xml");
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testFindTypesDataListModification() {
        List<String> initialList = Arrays.asList("Type1", "Type2");
        this.applicationModel = new DefaultApplicationModel("TestApp", this.mockArtifactAst, initialList, this.mockResourceResolver);
        List returnedList = this.applicationModel.findTypesDataList();
        Assert.assertNotSame(initialList, (Object)returnedList);
        Assert.assertEquals(initialList, (Object)returnedList);
    }

    @Test
    public void testDefault() {
        List<String> initialList = Arrays.asList("Type1", "Type2");
        this.applicationModel = new DefaultApplicationModel("TestApp", this.mockArtifactAst, initialList, this.mockResourceResolver);
        Assert.assertNotNull((Object)this.applicationModel.findResource("abc"));
    }
}

