/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.event.MuleEventExprBuilder;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.SetVariableTypeResolver;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class SetVariableTypeResolverTest {
    private SetVariableTypeResolver resolver;
    @Mock
    private MessageProcessorNode messageProcessorNode;
    @Mock
    private ComponentAst componentModel;
    @Mock
    private ComponentParameterAst variableNameParam;
    @Mock
    private ComponentParameterAst valueParam;
    @Mock
    private Either<String, Object> variableNameValue;
    @Mock
    private Either<String, Object> valueParamValue;
    @Mock
    private TypingMuleAstVisitor typingMuleAstVisitor;
    @Mock
    private TypingMuleAstVisitorContext visitorContext;

    @Before
    public void setup() {
        this.resolver = new SetVariableTypeResolver();
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)this.componentModel);
        Mockito.when((Object)this.componentModel.getParameter("General", "variableName")).thenReturn((Object)this.variableNameParam);
        Mockito.when((Object)this.variableNameParam.getValue()).thenReturn(this.variableNameValue);
        Mockito.when((Object)this.variableNameValue.getRight()).thenReturn((Object)"testVar");
        Mockito.when((Object)this.componentModel.getParameter("General", "value")).thenReturn((Object)this.valueParam);
        Mockito.when((Object)this.valueParam.getValue()).thenReturn(this.valueParamValue);
        Mockito.when((Object)((String)this.valueParamValue.getLeft())).thenReturn(null);
        Mockito.when((Object)this.valueParamValue.getRight()).thenReturn((Object)"testValue");
        Mockito.when((Object)this.valueParamValue.getValue()).thenReturn(Optional.of("testValue"));
    }

    @Test
    public void testGetComponentModelType() {
        Optional componentModelType = this.resolver.getComponentModelType();
        Assert.assertTrue((boolean)componentModelType.isPresent());
        Assert.assertEquals((Object)ComponentModelType.MESSAGE_PROCESSOR_NODE, componentModelType.get());
    }

    @Test
    public void testGetMuleEventExprBuilderConsumer() {
        EventType inputEventType = new EventType();
        Consumer consumer = this.resolver.getMuleEventExprBuilderConsumer(this.messageProcessorNode, inputEventType, this.typingMuleAstVisitor, this.visitorContext);
        Assert.assertNotNull((Object)consumer);
        MuleEventExprBuilder mockBuilder = (MuleEventExprBuilder)Mockito.mock(MuleEventExprBuilder.class);
        consumer.accept(mockBuilder);
        ((MuleEventExprBuilder)Mockito.verify((Object)mockBuilder)).variable((String)ArgumentMatchers.eq((Object)"testVar"), (Consumer)ArgumentMatchers.any());
    }

    @Test
    public void testIsPropagates() {
        Assert.assertTrue((boolean)this.resolver.isPropagates(this.messageProcessorNode));
    }
}

