/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.datasense.declarations.model.MessageProcessorTypeDeclaration;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.MessageProcessorTypeDeclarationAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.annotators.MessageProcessorTypeDeclarationAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.ast.api.ComponentAst;

public class MessageProcessorTypeDeclarationAnnotatorTest {
    private DataSenseProviderResolver dataSenseProviderResolver;
    private MessageProcessorNode messageProcessorNode;
    private AnnotatingMuleAstVisitorContext visitorContext;
    private ComponentAst componentAst;
    private MessageProcessorTypeDeclaration messageProcessorTypeDeclaration;

    @Before
    public void setUp() {
        this.dataSenseProviderResolver = (DataSenseProviderResolver)Mockito.mock(DataSenseProviderResolver.class);
        this.messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.visitorContext = (AnnotatingMuleAstVisitorContext)Mockito.mock(AnnotatingMuleAstVisitorContext.class);
        this.componentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.messageProcessorTypeDeclaration = (MessageProcessorTypeDeclaration)Mockito.mock(MessageProcessorTypeDeclaration.class);
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)this.componentAst);
        Mockito.when((Object)this.visitorContext.getDataSenseProviderResolver()).thenReturn((Object)this.dataSenseProviderResolver);
    }

    @Test
    public void testAnnotateWithTypeDeclaration() {
        Mockito.when((Object)this.messageProcessorNode.isSynthetic()).thenReturn((Object)false);
        Mockito.when((Object)this.dataSenseProviderResolver.findMessageProcessorTypeDeclaration(this.componentAst)).thenReturn(Optional.of(this.messageProcessorTypeDeclaration));
        MessageProcessorTypeDeclarationAnnotator annotator = new MessageProcessorTypeDeclarationAnnotator();
        annotator.annotate(this.messageProcessorNode, this.visitorContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((MessageProcessorTypeDeclarationAnnotation)Mockito.any(MessageProcessorTypeDeclarationAnnotation.class)));
    }

    @Test
    public void testAnnotateWithoutTypeDeclaration() {
        Mockito.when((Object)this.messageProcessorNode.isSynthetic()).thenReturn((Object)false);
        Mockito.when((Object)this.dataSenseProviderResolver.findMessageProcessorTypeDeclaration(this.componentAst)).thenReturn(Optional.empty());
        MessageProcessorTypeDeclarationAnnotator annotator = new MessageProcessorTypeDeclarationAnnotator();
        annotator.annotate(this.messageProcessorNode, this.visitorContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).annotate((AstNodeAnnotation)((MessageProcessorTypeDeclarationAnnotation)Mockito.any(MessageProcessorTypeDeclarationAnnotation.class)));
    }

    @Test
    public void testAnnotateForSyntheticMessageProcessor() {
        Mockito.when((Object)this.messageProcessorNode.isSynthetic()).thenReturn((Object)true);
        MessageProcessorTypeDeclarationAnnotator annotator = new MessageProcessorTypeDeclarationAnnotator();
        annotator.annotate(this.messageProcessorNode, this.visitorContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).annotate((AstNodeAnnotation)((MessageProcessorTypeDeclarationAnnotation)Mockito.any(MessageProcessorTypeDeclarationAnnotation.class)));
        ((DataSenseProviderResolver)Mockito.verify((Object)this.dataSenseProviderResolver, (VerificationMode)Mockito.never())).findMessageProcessorTypeDeclaration((ComponentAst)Mockito.any(ComponentAst.class));
    }
}

