/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.datasense.impl.model.ast.AstNodeLocation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.event.MuleEventExpr;
import org.mule.datasense.impl.model.event.MuleEventExprBuilder;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.datasense.impl.phases.typing.resolver.SetDataTypeResolver;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

public class SetDataTypeResolverTest {
    @Mock
    private MessageProcessorNode messageProcessorNode;
    @Mock
    private EventType inputEventType;
    @Mock
    private TypingMuleAstVisitor typingMuleAstVisitor;
    @Mock
    private TypingMuleAstVisitorContext visitorContext;
    @Mock
    private MuleEventExpr muleEventExpr;
    @Mock
    private MuleEventMetadataType muleEventMetadataType;
    private SetDataTypeResolver setDataTypeResolver;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.setDataTypeResolver = new TestSetDataTypeResolver();
    }

    @Test
    public void testGetComponentModelType() {
        Optional result = this.setDataTypeResolver.getComponentModelType();
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)ComponentModelType.MESSAGE_PROCESSOR_NODE, result.get());
    }

    @Test
    public void testResolve() {
        EventType expectedEventType = (EventType)Mockito.mock(EventType.class);
        Mockito.when((Object)this.muleEventExpr.resolveType((MuleEventMetadataType)Mockito.any(), (ResolveTypeContext)Mockito.any())).thenReturn((Object)this.muleEventMetadataType);
        Mockito.when((Object)this.visitorContext.getAstNotification()).thenReturn((Object)((AstNotification)Mockito.mock(AstNotification.class)));
        Mockito.when((Object)this.messageProcessorNode.getAstNodeLocation()).thenReturn((Object)((AstNodeLocation)Mockito.mock(AstNodeLocation.class)));
        Mockito.when((Object)this.visitorContext.getExpressionLanguageMetadataService()).thenReturn((Object)((ExpressionLanguageMetadataService)Mockito.mock(ExpressionLanguageMetadataService.class)));
        EventType result = this.setDataTypeResolver.resolve(this.messageProcessorNode, this.inputEventType, this.typingMuleAstVisitor, this.visitorContext);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testIsPropagates() {
        Assert.assertTrue((boolean)this.setDataTypeResolver.isPropagates(this.messageProcessorNode));
    }

    private class TestSetDataTypeResolver
    extends SetDataTypeResolver {
        private TestSetDataTypeResolver() {
        }

        protected Consumer<MuleEventExprBuilder> getMuleEventExprBuilderConsumer(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
            return builder -> builder.build();
        }
    }
}

