/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.datasense.impl.model.operation.OperationCallBuilder;
import org.mule.datasense.impl.phases.annotators.StaticDslBaseAnnotator;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

@RunWith(value=JUnit4.class)
public class StaticDslBaseAnnotator1Test {
    private StaticDslBaseAnnotator.OperationCallDslElementModelVisitor visitor;
    @Mock
    private OperationCallBuilder operationCallBuilder;
    @Mock
    private ComponentAst componentAst;
    @Mock
    private OperationModel operationModel;
    @Mock
    private OutputModel outputModel;
    @Mock
    private MetadataType metadataType;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.visitor = new StaticDslBaseAnnotator.OperationCallDslElementModelVisitor(this.operationCallBuilder);
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)this.outputModel);
        Mockito.when((Object)this.operationModel.getOutputAttributes()).thenReturn((Object)this.outputModel);
        Mockito.when((Object)this.outputModel.getType()).thenReturn((Object)this.metadataType);
    }

    @Test
    public void testVisitOperationModel_SetsNameAndErrors() {
        Mockito.when((Object)this.componentAst.getModel(OperationModel.class)).thenReturn(Optional.of(this.operationModel));
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"TestOperation");
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)this.outputModel);
        Mockito.when((Object)this.outputModel.getType()).thenReturn((Object)this.metadataType);
        this.visitor.visitOperationModel(this.componentAst);
        ((OperationCallBuilder)Mockito.verify((Object)this.operationCallBuilder)).name("TestOperation");
        ((OperationCallBuilder)Mockito.verify((Object)this.operationCallBuilder)).errors(this.operationModel.getErrorModels());
    }

    @Test
    public void testVisitOperationModel_Dynamic() throws IllegalAccessException, NoSuchFieldException {
        Mockito.when((Object)this.componentAst.getModel(OperationModel.class)).thenReturn(Optional.of(this.operationModel));
        Mockito.when((Object)this.operationModel.getName()).thenReturn((Object)"TestOperation");
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)this.outputModel);
        Mockito.when((Object)this.outputModel.getType()).thenReturn((Object)this.metadataType);
        Mockito.when((Object)this.outputModel.hasDynamicType()).thenReturn((Object)true);
        Field field = StaticDslBaseAnnotator.OperationCallDslElementModelVisitor.class.getDeclaredField("hasDynamicType");
        field.setAccessible(true);
        field.set(this.visitor, true);
        ComponentParameterAst componentParameterAst = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)this.componentAst.getParameters()).thenReturn(Arrays.asList(componentParameterAst));
        Mockito.when((Object)componentParameterAst.getModel()).thenReturn((Object)((ParameterModel)Mockito.mock(ParameterModel.class)));
        Mockito.when((Object)componentParameterAst.getModel().hasDynamicType()).thenReturn((Object)true);
        Mockito.when((Object)componentParameterAst.getValue()).thenReturn((Object)Either.right((Object)1));
        this.visitor.visitOperationModel(this.componentAst);
        ((OperationCallBuilder)Mockito.verify((Object)this.operationCallBuilder)).name("TestOperation");
        ((OperationCallBuilder)Mockito.verify((Object)this.operationCallBuilder)).errors(this.operationModel.getErrorModels());
    }

    @Test
    public void testHasDynamicType_InitiallyFalse() {
        Assert.assertFalse((boolean)this.visitor.isHasDynamicType());
    }

    @Test
    public void testVisitSourceModel() {
        SourceModel sourceModel = (SourceModel)Mockito.mock(SourceModel.class);
        Mockito.when((Object)this.componentAst.getModel(SourceModel.class)).thenReturn(Optional.of(sourceModel));
        Mockito.when((Object)sourceModel.getName()).thenReturn((Object)"TestOperation");
        Mockito.when((Object)sourceModel.getOutput()).thenReturn((Object)this.outputModel);
        Mockito.when((Object)this.outputModel.getType()).thenReturn((Object)this.metadataType);
        Mockito.when((Object)this.outputModel.hasDynamicType()).thenReturn((Object)true);
        Mockito.when((Object)sourceModel.getOutputAttributes()).thenReturn((Object)this.outputModel);
        this.visitor.visitSourceModel(this.componentAst);
        ((OperationCallBuilder)Mockito.verify((Object)this.operationCallBuilder)).name("TestOperation");
        ((OperationCallBuilder)Mockito.verify((Object)this.operationCallBuilder)).errors(this.operationModel.getErrorModels());
    }
}

