/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.types;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.LocalDateTimeType;
import org.mule.metadata.api.model.LocalTimeType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NothingType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.PeriodType;
import org.mule.metadata.api.model.RegexType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.TimeType;
import org.mule.metadata.api.model.TimeZoneType;
import org.mule.metadata.api.model.TypeParameterType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.model.VoidType;

public class TypeAssignability {
    public static boolean isEqual(MetadataType sourceType, MetadataType targetType, TypeParametersContext ctx) {
        return TypeAssignability.isAssignable(sourceType, targetType, ctx) && TypeAssignability.isAssignable(targetType, sourceType, ctx);
    }

    public static boolean isAssignable(MetadataType sourceType, MetadataType targetType, TypeParametersContext ctx) {
        boolean result;
        if (sourceType instanceof UnionType) {
            UnionType sourceUnionType = (UnionType)sourceType;
            List sourceTypes = sourceUnionType.getTypes();
            result = sourceTypes.stream().allMatch(innerSourceType -> TypeAssignability.isAssignable(innerSourceType, targetType, null));
        } else if (sourceType instanceof NothingType) {
            result = true;
        } else if (targetType instanceof ObjectType) {
            ObjectType targetObjectType = (ObjectType)targetType;
            Collection targetObjectFieldTypes = targetObjectType.getFields();
            if (sourceType instanceof ObjectType) {
                ObjectType sourceObjectType = (ObjectType)sourceType;
                TypeIdAnnotation targetTypeIdAnnotation = null;
                if (targetType.getMetadataFormat() == MetadataFormat.JAVA && sourceObjectType.getMetadataFormat() == MetadataFormat.JAVA) {
                    targetTypeIdAnnotation = targetObjectType.getAnnotation(TypeIdAnnotation.class).orElse(null);
                }
                if (targetTypeIdAnnotation != null) {
                    TypeIdAnnotation sourceTypeIdAnnotation = sourceObjectType.getAnnotation(TypeIdAnnotation.class).orElse(null);
                    if (sourceTypeIdAnnotation != null) {
                        try {
                            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                            Class<?> targetClazz = contextClassLoader.loadClass(targetTypeIdAnnotation.getValue());
                            Class<?> sourceClazz = contextClassLoader.loadClass(sourceTypeIdAnnotation.getValue());
                            result = targetClazz.isAssignableFrom(sourceClazz);
                        }
                        catch (ClassNotFoundException e) {
                            result = false;
                        }
                    } else {
                        result = false;
                    }
                } else {
                    Collection sourceObjectFieldTypes = sourceObjectType.getFields();
                    result = targetObjectFieldTypes.stream().allMatch(targetObjectFieldType -> !targetObjectFieldType.isRequired() || sourceObjectFieldTypes.stream().anyMatch(sourceObjectFieldType -> TypeAssignability.isAssignable((MetadataType)sourceObjectFieldType, (MetadataType)targetObjectFieldType, ctx)));
                }
            } else {
                result = false;
            }
        } else if (targetType instanceof ObjectFieldType) {
            ObjectFieldType targetObjectFieldType2 = (ObjectFieldType)targetType;
            if (sourceType instanceof ObjectFieldType) {
                ObjectFieldType sourceObjectFieldType = (ObjectFieldType)sourceType;
                result = (!targetObjectFieldType2.isRequired() || sourceObjectFieldType.isRequired()) && TypeAssignability.isAssignable((MetadataType)sourceObjectFieldType.getKey(), (MetadataType)targetObjectFieldType2.getKey(), ctx) && TypeAssignability.isAssignable(sourceObjectFieldType.getValue(), targetObjectFieldType2.getValue(), ctx);
            } else {
                result = false;
            }
        } else if (targetType instanceof ObjectKeyType) {
            ObjectKeyType sourceObjectKeyType;
            ObjectKeyType targetObjectKeyType = (ObjectKeyType)targetType;
            result = sourceType instanceof ObjectKeyType ? (sourceObjectKeyType = (ObjectKeyType)sourceType).getName().equals(targetObjectKeyType.getName()) && targetObjectKeyType.getAttributes().stream().allMatch(targetAttribute -> sourceObjectKeyType.getAttributes().stream().anyMatch(sourceAttribute -> TypeAssignability.isAssignable((MetadataType)sourceAttribute, (MetadataType)targetAttribute, ctx))) : false;
        } else if (targetType instanceof ArrayType) {
            ArrayType targetArrayType = (ArrayType)targetType;
            if (sourceType instanceof ArrayType) {
                ArrayType sourceArrayType = (ArrayType)sourceType;
                result = TypeAssignability.isAssignable(sourceArrayType.getType(), targetArrayType.getType(), ctx);
            } else {
                result = false;
            }
        } else if (targetType instanceof UnionType) {
            List targetTypes = ((UnionType)targetType).getTypes();
            result = targetTypes.stream().anyMatch(targetInnerType -> TypeAssignability.isAssignable(sourceType, targetInnerType, ctx));
        } else if (targetType instanceof TypeParameterType) {
            TypeParameterType expectedTypeParameterType = (TypeParameterType)targetType;
            String name = expectedTypeParameterType.getName();
            result = false;
        } else if (targetType instanceof FunctionType) {
            result = false;
        } else if (targetType instanceof AnyType) {
            result = true;
        } else if (targetType instanceof StringType) {
            result = sourceType instanceof StringType;
        } else if (targetType instanceof BooleanType) {
            result = sourceType instanceof BooleanType;
        } else if (targetType instanceof NumberType) {
            result = sourceType instanceof NumberType;
        } else if (targetType instanceof DateTimeType) {
            result = sourceType instanceof DateTimeType;
        } else if (targetType instanceof LocalDateTimeType) {
            result = sourceType instanceof LocalDateTimeType;
        } else if (targetType instanceof LocalTimeType) {
            result = sourceType instanceof LocalTimeType;
        } else if (targetType instanceof TimeType) {
            result = sourceType instanceof TimeType;
        } else if (targetType instanceof TimeZoneType) {
            result = sourceType instanceof TimeZoneType;
        } else if (targetType instanceof PeriodType) {
            result = sourceType instanceof PeriodType;
        } else if (targetType instanceof BinaryType) {
            result = sourceType instanceof BinaryType;
        } else if (targetType instanceof RegexType) {
            result = sourceType instanceof RegexType;
        } else if (targetType instanceof NullType) {
            result = sourceType instanceof NullType;
        } else if (targetType instanceof VoidType) {
            result = sourceType instanceof VoidType;
        } else {
            throw new IllegalArgumentException(String.format("Unsupported assignable check %s, %s", sourceType, targetType));
        }
        return result;
    }

    private static class TypeParametersContext {
        Map<String, MetadataType> context = new HashMap<String, MetadataType>();

        public Optional<MetadataType> get(String name) {
            return Optional.ofNullable(this.context.get(name));
        }
    }
}

