/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.datasense.impl.model.annotations.OperationCallBuilderAnnotation;
import org.mule.datasense.impl.model.annotations.metadata.SourceModelAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.operation.OperationCallBuilder;
import org.mule.datasense.impl.phases.annotators.StaticDslSourceAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;

public class StaticDslSourceAnnotatorTest {
    private StaticDslSourceAnnotator annotator;
    private MessageProcessorNode messageProcessorNode;
    private AnnotatingMuleAstVisitorContext context;
    private ComponentAst componentAst;
    private SourceModel sourceModel;
    private OperationCallBuilder operationCallBuilder;

    @Before
    public void setUp() {
        this.annotator = new StaticDslSourceAnnotator();
        this.messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        this.context = (AnnotatingMuleAstVisitorContext)Mockito.mock(AnnotatingMuleAstVisitorContext.class);
        this.componentAst = (ComponentAst)Mockito.mock(ComponentAst.class);
        this.sourceModel = (SourceModel)Mockito.mock(SourceModel.class);
        this.operationCallBuilder = (OperationCallBuilder)Mockito.mock(OperationCallBuilder.class);
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)this.componentAst);
        Mockito.when((Object)this.componentAst.getModel(SourceModel.class)).thenReturn(Optional.of(this.sourceModel));
    }

    @Test(expected=Exception.class)
    public void testAnnotateWithSourceModel_throwsError() {
        OperationCallBuilderAnnotation astNodeAnnotation = (OperationCallBuilderAnnotation)Mockito.mock(OperationCallBuilderAnnotation.class);
        ComponentParameterAst componentParameterAst = (ComponentParameterAst)Mockito.mock(ComponentParameterAst.class);
        Mockito.when((Object)((OperationCallBuilderAnnotation)this.messageProcessorNode.getOrCreateAnnotation((Class)Mockito.eq(OperationCallBuilderAnnotation.class), (Supplier)Mockito.any()))).thenReturn((Object)astNodeAnnotation);
        Mockito.when((Object)astNodeAnnotation.getOperationCallBuilder()).thenReturn((Object)this.operationCallBuilder);
        Mockito.when((Object)this.messageProcessorNode.getComponentModel().getParameter(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)componentParameterAst);
        Mockito.when((Object)componentParameterAst.getValue()).thenReturn((Object)Either.right((Object)"test"));
        this.annotator.annotate(this.messageProcessorNode, this.context);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((SourceModelAnnotation)Mockito.any(SourceModelAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).getOrCreateAnnotation((Class)Mockito.eq(OperationCallBuilderAnnotation.class), (Supplier)Mockito.any());
    }

    @Test
    public void testAnnotateWithoutSourceModel() {
        Mockito.when((Object)this.componentAst.getModel(SourceModel.class)).thenReturn(Optional.empty());
        this.annotator.annotate(this.messageProcessorNode, this.context);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).annotate((AstNodeAnnotation)((SourceModelAnnotation)Mockito.any(SourceModelAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).getOrCreateAnnotation((Class)Mockito.eq(OperationCallBuilderAnnotation.class), (Supplier)Mockito.any());
    }
}

