/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.httppolicy;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.httppolicy.HttpPolicyExecuteNextTypeResolver;

public class HttpPolicyExecuteNextTypeResolverTest {
    private HttpPolicyExecuteNextTypeResolver resolver;
    @Mock
    private MessageProcessorNode messageProcessorNode;
    @Mock
    private TypingMuleAstVisitor typingMuleAstVisitor;
    @Mock
    private TypingMuleAstVisitorContext visitorContext;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.resolver = new HttpPolicyExecuteNextTypeResolver();
    }

    @Test
    public void testResolve() {
        EventType inputEventType = new EventType();
        EventType result = this.resolver.resolve(this.messageProcessorNode, inputEventType, this.typingMuleAstVisitor, this.visitorContext);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((UsesTypeAnnotation)Mockito.any(UsesTypeAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((DefinesTypeAnnotation)Mockito.any(DefinesTypeAnnotation.class)));
        Assert.assertEquals((Object)inputEventType, (Object)result);
    }

    @Test
    public void testIsPropagates() {
        boolean result = this.resolver.isPropagates(this.messageProcessorNode);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testAnnotationsAreCorrectType() {
        EventType inputEventType = new EventType();
        this.resolver.resolve(this.messageProcessorNode, inputEventType, this.typingMuleAstVisitor, this.visitorContext);
        Assert.assertNotNull((Object)inputEventType);
    }
}

