/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.tooling;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.HasDynamicMetadataAnnotation;
import org.mule.datasense.impl.model.annotations.OperationCallAnnotation;
import org.mule.datasense.impl.model.annotations.metadata.OperationModelAnnotation;
import org.mule.datasense.impl.model.annotations.metadata.SourceModelAnnotation;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.tooling.MetadataQuery;
import org.mule.datasense.impl.tooling.MetadataQueryResult;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.ast.api.ComponentAst;

@RunWith(value=MockitoJUnitRunner.class)
public class MetadataQueryTest {
    @Mock
    private MuleApplicationNode muleApplicationNode;
    @Mock
    private DataSenseProviderResolver dataSenseProviderResolver;
    @Mock
    DataSenseProvider dataSenseProvider;
    @Mock
    private AstNotification astNotification;
    @Mock
    private MessageProcessorNode messageProcessorNode;
    @Mock
    private OperationModel operationModel;
    @Mock
    private SourceModel sourceModel;
    @Mock
    private OperationCallAnnotation operationCallAnnotation;
    private MetadataQuery metadataQuery;
    private Location location;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.location = (Location)Mockito.mock(Location.class);
        this.metadataQuery = new MetadataQuery(this.location);
    }

    @Test
    public void testPerformWithNoMessageProcessor() {
        Mockito.when((Object)this.muleApplicationNode.findMessageProcessorNode(this.location)).thenReturn(Optional.empty());
        Optional result = this.metadataQuery.perform(this.muleApplicationNode, this.dataSenseProviderResolver, this.astNotification);
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testPerformWithOperationModel() {
        this.setupMessageProcessorNode();
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(OperationModelAnnotation.class)).thenReturn(Optional.of(new OperationModelAnnotation(this.operationModel)));
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(SourceModelAnnotation.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.dataSenseProviderResolver.getDataSenseProvider()).thenReturn((Object)this.dataSenseProvider);
        Optional result = this.metadataQuery.perform(this.muleApplicationNode, this.dataSenseProviderResolver, this.astNotification);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertNotNull((Object)((MetadataQueryResult)result.get()).getOperationModel());
        Assert.assertEquals((Object)((MetadataQueryResult)result.get()).getSourceModel(), Optional.empty());
    }

    @Test
    public void testPerformWithSourceModel() {
        this.setupMessageProcessorNode();
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(OperationModelAnnotation.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(SourceModelAnnotation.class)).thenReturn(Optional.of(new SourceModelAnnotation(this.sourceModel)));
        Mockito.when((Object)this.dataSenseProviderResolver.getDataSenseProvider()).thenReturn((Object)this.dataSenseProvider);
        Optional result = this.metadataQuery.perform(this.muleApplicationNode, this.dataSenseProviderResolver, this.astNotification);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)((MetadataQueryResult)result.get()).getOperationModel(), Optional.empty());
        Assert.assertNotNull((Object)((MetadataQueryResult)result.get()).getSourceModel());
    }

    @Test
    public void testPerformWithBothModels() {
        this.setupMessageProcessorNode();
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(OperationModelAnnotation.class)).thenReturn(Optional.of(new OperationModelAnnotation(this.operationModel)));
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(SourceModelAnnotation.class)).thenReturn(Optional.of(new SourceModelAnnotation(this.sourceModel)));
        Mockito.when((Object)this.dataSenseProviderResolver.getDataSenseProvider()).thenReturn((Object)this.dataSenseProvider);
        Optional result = this.metadataQuery.perform(this.muleApplicationNode, this.dataSenseProviderResolver, this.astNotification);
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertNotNull((Object)((MetadataQueryResult)result.get()).getOperationModel());
        Assert.assertNotNull((Object)((MetadataQueryResult)result.get()).getSourceModel());
    }

    @Test
    public void testEnrichOperationModelWithDynamicMetadata() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = MetadataQuery.class.getDeclaredMethod("enrichOperationModel", MessageProcessorNode.class, OperationModel.class, DataSenseProviderResolver.class, AstNotification.class);
        method.setAccessible(true);
        this.setupDynamicMetadata();
        this.setupMessageProcessorNode();
        try {
            OperationModel operationModel = (OperationModel)method.invoke((Object)this.metadataQuery, this.messageProcessorNode, this.operationModel, this.dataSenseProviderResolver, this.astNotification);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof InvocationTargetException));
        }
    }

    @Test
    public void testEnrichSourceModelWithDynamicMetadata() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = MetadataQuery.class.getDeclaredMethod("enrichSourceModel", MessageProcessorNode.class, SourceModel.class, DataSenseProviderResolver.class, AstNotification.class);
        method.setAccessible(true);
        this.setupDynamicMetadata();
        this.setupMessageProcessorNode();
        try {
            OperationModel operationModel = (OperationModel)method.invoke((Object)this.metadataQuery, this.messageProcessorNode, this.sourceModel, this.dataSenseProviderResolver, this.astNotification);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof InvocationTargetException));
        }
    }

    private void setupMessageProcessorNode() {
        Mockito.when((Object)this.muleApplicationNode.findMessageProcessorNode(this.location)).thenReturn(Optional.of(this.messageProcessorNode));
    }

    private void setupDynamicMetadata() {
        Mockito.when((Object)this.messageProcessorNode.isAnnotatedWith(HasDynamicMetadataAnnotation.class)).thenReturn((Object)true);
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(OperationCallAnnotation.class)).thenReturn(Optional.of(this.operationCallAnnotation));
        Mockito.when((Object)this.dataSenseProviderResolver.getDataSenseProvider()).thenReturn((Object)((DataSenseProvider)Mockito.mock(DataSenseProvider.class)));
        Mockito.when((Object)this.dataSenseProviderResolver.getDataSenseProvider().getDataSenseMetadataProvider()).thenReturn(Optional.of((DataSenseMetadataProvider)Mockito.mock(DataSenseMetadataProvider.class)));
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)((ComponentAst)Mockito.mock(ComponentAst.class)));
        Mockito.when((Object)this.operationModel.getOutputAttributes()).thenReturn((Object)((OutputModel)Mockito.mock(OutputModel.class)));
        Mockito.when((Object)this.operationModel.getOutput()).thenReturn((Object)((OutputModel)Mockito.mock(OutputModel.class)));
    }
}

