/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.mule.datasense.impl.model.annotations.OperationCallAnnotation;
import org.mule.datasense.impl.model.annotations.OperationCallBuilderAnnotation;
import org.mule.datasense.impl.model.annotations.TypeResolverAnnotation;
import org.mule.datasense.impl.model.annotations.VoidOperationAnnotation;
import org.mule.datasense.impl.model.ast.AstNodeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.operation.OperationCall;
import org.mule.datasense.impl.model.operation.OperationCallBuilder;
import org.mule.datasense.impl.phases.annotators.OperationCallAnnotator;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.runtime.ast.api.ComponentAst;

public class OperationCallAnnotatorTest {
    private OperationCallAnnotator annotator;
    @Mock
    private MessageProcessorNode messageProcessorNode;
    @Mock
    private AnnotatingMuleAstVisitorContext context;
    @Mock
    private OperationCallBuilderAnnotation operationCallBuilderAnnotation;
    @Mock
    private OperationCallBuilder operationCallBuilder;
    @Mock
    private OperationCall operationCall;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.annotator = new OperationCallAnnotator();
    }

    @Test
    public void testAnnotateRootMessageProcessorNode() {
        Mockito.when((Object)this.messageProcessorNode.isRootMessageProcessorNode()).thenReturn((Object)true);
        this.annotator.annotate(this.messageProcessorNode, this.context);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode, (VerificationMode)Mockito.never())).getAnnotation(TypeResolverAnnotation.class);
    }

    @Test
    public void testAnnotateWithExistingTypeResolverAnnotation() {
        Mockito.when((Object)this.messageProcessorNode.isRootMessageProcessorNode()).thenReturn((Object)false);
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(TypeResolverAnnotation.class)).thenReturn(Optional.of((TypeResolverAnnotation)Mockito.mock(TypeResolverAnnotation.class)));
        this.annotator.annotate(this.messageProcessorNode, this.context);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).getComponentIdentifier();
    }

    @Test
    public void testAnnotateOperationCall() {
        Mockito.when((Object)this.messageProcessorNode.isRootMessageProcessorNode()).thenReturn((Object)false);
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(TypeResolverAnnotation.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(OperationCallBuilderAnnotation.class)).thenReturn(Optional.of(this.operationCallBuilderAnnotation));
        Mockito.when((Object)this.operationCallBuilderAnnotation.getOperationCallBuilder()).thenReturn((Object)this.operationCallBuilder);
        Mockito.when((Object)this.operationCallBuilder.build()).thenReturn((Object)this.operationCall);
        this.annotator.annotate(this.messageProcessorNode, this.context);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((OperationCallAnnotation)Mockito.any(OperationCallAnnotation.class)));
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((TypeResolverAnnotation)Mockito.any(TypeResolverAnnotation.class)));
    }

    @Test
    public void testAnnotateVoidOperation() {
        Mockito.when((Object)this.messageProcessorNode.isRootMessageProcessorNode()).thenReturn((Object)false);
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(TypeResolverAnnotation.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(OperationCallBuilderAnnotation.class)).thenReturn(Optional.of(this.operationCallBuilderAnnotation));
        Mockito.when((Object)this.operationCallBuilderAnnotation.getOperationCallBuilder()).thenReturn((Object)this.operationCallBuilder);
        Mockito.when((Object)this.operationCallBuilder.build()).thenReturn((Object)this.operationCall);
        MessageMetadataType messageMetadataType = (MessageMetadataType)Mockito.mock(MessageMetadataType.class);
        Mockito.when((Object)this.operationCall.getReturnType()).thenReturn((Object)messageMetadataType);
        Mockito.when((Object)messageMetadataType.getPayloadType()).thenReturn(Optional.of((MetadataType)Mockito.mock(VoidType.class)));
        Mockito.when((Object)messageMetadataType.getAttributesType()).thenReturn(Optional.of((MetadataType)Mockito.mock(VoidType.class)));
        this.annotator.annotate(this.messageProcessorNode, this.context);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((VoidOperationAnnotation)Mockito.any(VoidOperationAnnotation.class)));
    }

    @Test
    public void testAnnotateAllowListedOperation() {
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(OperationCallBuilderAnnotation.class)).thenReturn(Optional.of(this.operationCallBuilderAnnotation));
        Mockito.when((Object)this.operationCallBuilderAnnotation.getOperationCallBuilder()).thenReturn((Object)this.operationCallBuilder);
        Mockito.when((Object)this.operationCallBuilder.build()).thenReturn((Object)this.operationCall);
        this.annotator.annotate(this.messageProcessorNode, this.context);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).annotate((AstNodeAnnotation)((OperationCallAnnotation)Mockito.any(OperationCallAnnotation.class)));
    }

    @Test
    public void testAnnotateMessageProcessorNode() {
        Mockito.when((Object)this.messageProcessorNode.isRootMessageProcessorNode()).thenReturn((Object)false);
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(TypeResolverAnnotation.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)((ComponentAst)Mockito.mock(ComponentAst.class)));
        Mockito.when((Object)this.messageProcessorNode.getComponentModelType()).thenReturn(Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE));
        this.annotator.annotate(this.messageProcessorNode, this.context);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).getComponentModelType();
    }

    @Test
    public void testAnnotateMessageSourceNode() {
        Mockito.when((Object)this.messageProcessorNode.isRootMessageProcessorNode()).thenReturn((Object)false);
        Mockito.when((Object)this.messageProcessorNode.getAnnotation(TypeResolverAnnotation.class)).thenReturn(Optional.empty());
        Mockito.when((Object)this.messageProcessorNode.getComponentModelType()).thenReturn(Optional.of(ComponentModelType.MESSAGE_SOURCE_NODE));
        Mockito.when((Object)this.messageProcessorNode.getComponentModel()).thenReturn((Object)((ComponentAst)Mockito.mock(ComponentAst.class)));
        this.annotator.annotate(this.messageProcessorNode, this.context);
        ((MessageProcessorNode)Mockito.verify((Object)this.messageProcessorNode)).getComponentModelType();
    }
}

