/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.event;

import java.io.InputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mule.datasense.impl.model.event.LiteralValueExpr;
import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

@RunWith(value=JUnit4.class)
public class LiteralValueExprTest {
    @Mock
    private MuleEventMetadataType mockMuleEventMetadataType;
    @Mock
    private ResolveTypeContext mockResolveTypeContext;
    @Mock
    private ExpressionLanguageMetadataService mockExpressionLanguageMetadataService;
    private LiteralValueExpr literalValueExpr;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockResolveTypeContext.getExpressionLanguageMetadataService()).thenReturn((Object)this.mockExpressionLanguageMetadataService);
    }

    @Test
    public void testConstructorWithValidInput() {
        this.literalValueExpr = new LiteralValueExpr("test", "text/plain");
        Assert.assertNotNull((Object)this.literalValueExpr);
    }

    @Test(expected=NullPointerException.class)
    public void testConstructorWithNullValue() {
        new LiteralValueExpr(null, "text/plain");
    }

    @Test
    public void testResolveTypeWithNullMimeType() {
        this.literalValueExpr = new LiteralValueExpr("test", null);
        MetadataType result = this.literalValueExpr.resolveType(this.mockMuleEventMetadataType, this.mockResolveTypeContext);
        Assert.assertTrue((boolean)(result instanceof StringType));
    }

    @Test
    public void testResolveTypeWithApplicationJavaMimeType() {
        this.literalValueExpr = new LiteralValueExpr("test", "application/java");
        MetadataType result = this.literalValueExpr.resolveType(this.mockMuleEventMetadataType, this.mockResolveTypeContext);
        Assert.assertTrue((boolean)(result instanceof StringType));
    }

    @Test
    public void testResolveTypeWithNonJavaMimeType() {
        this.literalValueExpr = new LiteralValueExpr("test", "application/json");
        MetadataType mockMetadataType = (MetadataType)Mockito.mock(MetadataType.class);
        Mockito.when((Object)this.mockExpressionLanguageMetadataService.getMetadataFromSample((InputStream)Mockito.any(InputStream.class), Mockito.anyMap(), (String)Mockito.eq((Object)"application/json"))).thenReturn((Object)mockMetadataType);
        MetadataType result = this.literalValueExpr.resolveType(this.mockMuleEventMetadataType, this.mockResolveTypeContext);
        Assert.assertEquals((Object)mockMetadataType, (Object)result);
    }

    @Test
    public void testResolveTypeWithExceptionThrown() {
        this.literalValueExpr = new LiteralValueExpr("test", "application/json");
        Mockito.when((Object)this.mockExpressionLanguageMetadataService.getMetadataFromSample((InputStream)Mockito.any(InputStream.class), Mockito.anyMap(), (String)Mockito.eq((Object)"application/json"))).thenThrow(new Throwable[]{new RuntimeException("Test exception")});
        MetadataType result = this.literalValueExpr.resolveType(this.mockMuleEventMetadataType, this.mockResolveTypeContext);
        Assert.assertTrue((boolean)(result instanceof AnyType));
    }

    @Test
    public void testResolveInputType() {
        this.literalValueExpr = new LiteralValueExpr("test", "text/plain");
        MetadataType mockMetadataType = (MetadataType)Mockito.mock(MetadataType.class);
        MuleEventMetadataTypeBuilder mockBuilder = (MuleEventMetadataTypeBuilder)Mockito.mock(MuleEventMetadataTypeBuilder.class);
        this.literalValueExpr.resolveInputType(mockMetadataType, mockBuilder, this.mockResolveTypeContext);
        Mockito.verifyNoInteractions((Object[])new Object[]{mockMetadataType, mockBuilder, this.mockResolveTypeContext});
    }
}

