/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.datasense.impl.model.ast.AstNode;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.typing.BaseTypeResolverTestOld;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.ChoiceTypeResolver;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolver;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;
import org.mule.runtime.ast.api.ComponentAst;

@RunWith(value=Parameterized.class)
public class ChoiceTypeResolverTest
extends BaseTypeResolverTestOld {
    private static final TypingMuleAstVisitor typingMuleAstVisitor = (TypingMuleAstVisitor)Mockito.mock(TypingMuleAstVisitor.class);

    public ChoiceTypeResolverTest(String name, Supplier<MuleEventMetadataTypeBuilder> inputMuleEventMetadataTypeBuilderSupplier, Supplier<List<MessageProcessorNode>> messageProcessorNodeList, Supplier<TypingMuleAstVisitor> typingMuleAstVisitor, String usesMetadataTypeData, String definesMetadataTypeData, String resultMetadataTypeData) {
        super(name, "choice", inputMuleEventMetadataTypeBuilderSupplier, () -> (ComponentAst)Mockito.mock(ComponentAst.class), messageProcessorNodeList, typingMuleAstVisitor, null, usesMetadataTypeData, definesMetadataTypeData, resultMetadataTypeData);
    }

    private static MessageProcessorNode createChildProcessorNode(Supplier<MuleEventMetadataTypeBuilder> muleEventMetadataTypeBuilderSupplier) {
        MessageProcessorNode messageProcessorNode = (MessageProcessorNode)Mockito.mock(MessageProcessorNode.class);
        ComponentAst componentModel = (ComponentAst)Mockito.mock(ComponentAst.class);
        Mockito.when((Object)messageProcessorNode.getComponentModel()).thenReturn((Object)componentModel);
        Mockito.when((Object)typingMuleAstVisitor.resolveType((AstNode)ArgumentMatchers.same((Object)messageProcessorNode), (EventType)ArgumentMatchers.any(EventType.class), (TypingMuleAstVisitorContext)ArgumentMatchers.any(TypingMuleAstVisitorContext.class))).thenReturn((Object)TypeUtils.asEventType((MuleEventMetadataType)muleEventMetadataTypeBuilderSupplier.get().build()));
        return messageProcessorNode;
    }

    private static List<Object[]> choiceWithSingleChild() {
        String usesMetadataType = "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}";
        return Arrays.asList({"choice-single-child-payload", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            return muleEventMetadataTypeBuilder;
        }, () -> {
            ArrayList<MessageProcessorNode> messageProcessorNodeList = new ArrayList<MessageProcessorNode>();
            messageProcessorNodeList.add(ChoiceTypeResolverTest.createChildProcessorNode(() -> {
                MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
                muleEventMetadataTypeBuilder.message().payload().stringType();
                return muleEventMetadataTypeBuilder;
            }));
            return messageProcessorNodeList;
        }, () -> typingMuleAstVisitor, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : String\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : String\n  }, \n  \"variables\" : {\n\n  }\n}"}, {"choice-single-child-attributes", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            return muleEventMetadataTypeBuilder;
        }, () -> {
            ArrayList<MessageProcessorNode> messageProcessorNodeList = new ArrayList<MessageProcessorNode>();
            messageProcessorNodeList.add(ChoiceTypeResolverTest.createChildProcessorNode(() -> {
                MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
                muleEventMetadataTypeBuilder.message().attributes().stringType();
                return muleEventMetadataTypeBuilder;
            }));
            return messageProcessorNodeList;
        }, () -> typingMuleAstVisitor, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"attributes\" : String\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"attributes\" : String\n  }, \n  \"variables\" : {\n\n  }\n}"}, {"choice-single-child-variable", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            return muleEventMetadataTypeBuilder;
        }, () -> {
            ArrayList<MessageProcessorNode> messageProcessorNodeList = new ArrayList<MessageProcessorNode>();
            messageProcessorNodeList.add(ChoiceTypeResolverTest.createChildProcessorNode(() -> {
                MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
                muleEventMetadataTypeBuilder.addVariable("var").stringType();
                return muleEventMetadataTypeBuilder;
            }));
            return messageProcessorNodeList;
        }, () -> typingMuleAstVisitor, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n    \"var\" : String\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n    \"var\" : String\n  }\n}"});
    }

    private static List<Object[]> choiceWithMultipleChildre() {
        String usesMetadataType = "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}";
        return Arrays.asList({"choice-multiple-children-payload", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            return muleEventMetadataTypeBuilder;
        }, () -> Arrays.asList(ChoiceTypeResolverTest.createChildProcessorNode(() -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.message().payload().stringType();
            return muleEventMetadataTypeBuilder;
        }), ChoiceTypeResolverTest.createChildProcessorNode(() -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.message().payload().numberType();
            return muleEventMetadataTypeBuilder;
        })), () -> typingMuleAstVisitor, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : String | Number\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"payload\" : String | Number\n  }, \n  \"variables\" : {\n\n  }\n}"}, {"choice-multiple-children-attributes", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            return muleEventMetadataTypeBuilder;
        }, () -> Arrays.asList(ChoiceTypeResolverTest.createChildProcessorNode(() -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.message().attributes().stringType();
            return muleEventMetadataTypeBuilder;
        }), ChoiceTypeResolverTest.createChildProcessorNode(() -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.message().attributes().numberType();
            return muleEventMetadataTypeBuilder;
        })), () -> typingMuleAstVisitor, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"attributes\" : String | Number\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n    \"attributes\" : String | Number\n  }, \n  \"variables\" : {\n\n  }\n}"}, {"choice-multiple-children-variable", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            return muleEventMetadataTypeBuilder;
        }, () -> Arrays.asList(ChoiceTypeResolverTest.createChildProcessorNode(() -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.addVariable("var").stringType();
            return muleEventMetadataTypeBuilder;
        }), ChoiceTypeResolverTest.createChildProcessorNode(() -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
            muleEventMetadataTypeBuilder.addVariable("var").numberType();
            return muleEventMetadataTypeBuilder;
        })), () -> typingMuleAstVisitor, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n    \"var\" : String | Number\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n    \"var\" : String | Number\n  }\n}"});
    }

    private static List<Object[]> choiceWithNoChild() {
        return Arrays.asList(new Object[][]{{"choice-1", () -> {
            MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
            return muleEventMetadataTypeBuilder;
        }, () -> Collections.emptyList(), () -> typingMuleAstVisitor, "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}", "%type _:Java = {\n  \"message\" : @typeId(\"value\" : \"org.mule.runtime.api.message.Message\") {\n\n  }, \n  \"variables\" : {\n\n  }\n}"}});
    }

    @Override
    public Optional<TypeResolver> createTypeResolver() {
        return Optional.of(new ChoiceTypeResolver());
    }

    @Parameterized.Parameters(name="{0}-{index}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        parameters.addAll(ChoiceTypeResolverTest.choiceWithNoChild());
        parameters.addAll(ChoiceTypeResolverTest.choiceWithSingleChild());
        parameters.addAll(ChoiceTypeResolverTest.choiceWithMultipleChildre());
        return parameters;
    }
}

