/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.model.TypeParameterType;
import org.mule.metadata.api.model.impl.DefaultAnyType;
import org.mule.metadata.api.model.impl.DefaultArrayType;

public class MetadataTypeUnification {
    public Optional<Map<String, MetadataType>> unify(MetadataType metadataType1, MetadataType metadataType2) {
        if (metadataType1 instanceof TypeParameterType) {
            HashMap<String, MetadataType> substitutions = new HashMap<String, MetadataType>();
            substitutions.put(((TypeParameterType)metadataType1).getName(), metadataType2);
            return Optional.of(substitutions);
        }
        if (metadataType2 instanceof TypeParameterType) {
            HashMap<String, MetadataType> substitutions = new HashMap<String, MetadataType>();
            substitutions.put(((TypeParameterType)metadataType2).getName(), metadataType1);
            return Optional.of(substitutions);
        }
        if (metadataType1 instanceof DefaultAnyType && metadataType2 instanceof DefaultAnyType) {
            return Optional.of(Collections.emptyMap());
        }
        if (metadataType1 instanceof DefaultArrayType && metadataType2 instanceof DefaultArrayType) {
            return this.unifyArrayTypes((DefaultArrayType)metadataType1, (DefaultArrayType)metadataType2);
        }
        if (metadataType1 instanceof SimpleType && metadataType2 instanceof SimpleType) {
            return Optional.of(Collections.emptyMap());
        }
        return Optional.empty();
    }

    private Optional<Map<String, MetadataType>> unifyArrayTypes(DefaultArrayType arrayType1, DefaultArrayType arrayType2) {
        return this.unify(arrayType1.getType(), arrayType2.getType());
    }
}

