/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.util;

import org.junit.Assert;
import org.junit.Test;
import org.mule.datasense.impl.util.MetadataTypeReader;
import org.mule.datasense.impl.util.Parsers;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;

public class MetadataTypeReaderTest {
    @Test
    public void testParseNumber() throws Parsers.Failure {
        TypeBuilder result = (TypeBuilder)MetadataTypeReader.parseNumber.parse((CharSequence)"Number");
        Assert.assertFalse((boolean)(result instanceof BaseTypeBuilder));
        Assert.assertEquals((Object)MetadataFormat.JAVA, (Object)result.build().getMetadataFormat());
    }

    @Test
    public void testParseString() throws Parsers.Failure {
        TypeBuilder result = (TypeBuilder)MetadataTypeReader.parseString.parse((CharSequence)"String");
        Assert.assertFalse((boolean)(result instanceof BaseTypeBuilder));
        Assert.assertEquals((Object)MetadataFormat.JAVA, (Object)result.build().getMetadataFormat());
    }

    @Test
    public void testParseBoolean() throws Parsers.Failure {
        TypeBuilder result = (TypeBuilder)MetadataTypeReader.parseBoolean.parse((CharSequence)"Boolean");
        Assert.assertFalse((boolean)(result instanceof BaseTypeBuilder));
        Assert.assertEquals((Object)MetadataFormat.JAVA, (Object)result.build().getMetadataFormat());
    }

    @Test
    public void testParseArray() throws Parsers.Failure {
        TypeBuilder result = (TypeBuilder)MetadataTypeReader.parseArray.parse((CharSequence)"[String]");
        Assert.assertTrue((boolean)(result instanceof ArrayTypeBuilder));
    }

    @Test
    public void testParseObject() throws Parsers.Failure {
        TypeBuilder result = (TypeBuilder)MetadataTypeReader.parseObject.parse((CharSequence)"{name: String, age: Number}");
        Assert.assertTrue((boolean)(result instanceof ObjectTypeBuilder));
    }

    @Test(expected=Parsers.Failure.class)
    public void testInvalidInput() throws Parsers.Failure {
        MetadataTypeReader.parse.parse((CharSequence)"Invalid Input");
    }

    @Test
    public void testParseTuple() throws Parsers.Failure {
        TypeBuilder result = (TypeBuilder)MetadataTypeReader.parseTuple.parse((CharSequence)"<String, Number, Boolean>");
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.build());
    }
}

